/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.core;

import ccmm.architecture.Architecture;

import ccmm.basic.NamedElement;

import ccmm.repository.Repository;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Component Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link ccmm.core.ComponentType#getProvidedInterfaces <em>Provided Interfaces</em>}</li>
 *   <li>{@link ccmm.core.ComponentType#getRequiredInterfaces <em>Required Interfaces</em>}</li>
 *   <li>{@link ccmm.core.ComponentType#getArchitecture <em>Architecture</em>}</li>
 *   <li>{@link ccmm.core.ComponentType#getRepository <em>Repository</em>}</li>
 * </ul>
 * </p>
 *
 * @see ccmm.core.CorePackage#getComponentType()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore constraints='distinctInterfaceNames distinctRepositoryNames3'"
 *        annotation="http://www.eclipse.org/ocl/examples/OCL distinctInterfaceNames='(self.providedInterfaces->union(self.requiredInterfaces))->isUnique(i | i.name)  \r\n' distinctRepositoryNames3='self.repository.types->select(t | t.name = self.name)->size() = 0 and\r\nself.repository.interfaceTypes->select(it | it.name = self.name)->size() = 0 and\r\nself.repository.componentTypes->select(ct | ct.name = self.name)->size() = 1'"
 * @generated
 */
public interface ComponentType extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Provided Interfaces</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.core.Interface}.
	 * It is bidirectional and its opposite is '{@link ccmm.core.Interface#getPComponentType <em>PComponent Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Provided Interfaces</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Provided Interfaces</em>' containment reference list.
	 * @see ccmm.core.CorePackage#getComponentType_ProvidedInterfaces()
	 * @see ccmm.core.Interface#getPComponentType
	 * @model opposite="pComponentType" containment="true"
	 * @generated
	 */
	EList<Interface> getProvidedInterfaces();

	/**
	 * Returns the value of the '<em><b>Required Interfaces</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.core.Interface}.
	 * It is bidirectional and its opposite is '{@link ccmm.core.Interface#getRComponentType <em>RComponent Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Required Interfaces</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Required Interfaces</em>' containment reference list.
	 * @see ccmm.core.CorePackage#getComponentType_RequiredInterfaces()
	 * @see ccmm.core.Interface#getRComponentType
	 * @model opposite="rComponentType" containment="true"
	 * @generated
	 */
	EList<Interface> getRequiredInterfaces();

	/**
	 * Returns the value of the '<em><b>Architecture</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link ccmm.architecture.Architecture#getComponentType <em>Component Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Architecture</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Architecture</em>' containment reference.
	 * @see #setArchitecture(Architecture)
	 * @see ccmm.core.CorePackage#getComponentType_Architecture()
	 * @see ccmm.architecture.Architecture#getComponentType
	 * @model opposite="componentType" containment="true"
	 * @generated
	 */
	Architecture getArchitecture();

	/**
	 * Sets the value of the '{@link ccmm.core.ComponentType#getArchitecture <em>Architecture</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Architecture</em>' containment reference.
	 * @see #getArchitecture()
	 * @generated
	 */
	void setArchitecture(Architecture value);

	/**
	 * Returns the value of the '<em><b>Repository</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link ccmm.repository.Repository#getComponentTypes <em>Component Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Repository</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Repository</em>' container reference.
	 * @see #setRepository(Repository)
	 * @see ccmm.core.CorePackage#getComponentType_Repository()
	 * @see ccmm.repository.Repository#getComponentTypes
	 * @model opposite="componentTypes" required="true"
	 * @generated
	 */
	Repository getRepository();

	/**
	 * Sets the value of the '{@link ccmm.core.ComponentType#getRepository <em>Repository</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Repository</em>' container reference.
	 * @see #getRepository()
	 * @generated
	 */
	void setRepository(Repository value);

} // ComponentType
