package test;

import ccmm.architecture.*;
import ccmm.architecture.impl.*;
import ccmm.architecture.util.*;
import ccmm.basic.*;
import ccmm.basic.impl.*;
import ccmm.basic.util.*;
import ccmm.core.*;
import ccmm.core.impl.*;
import ccmm.core.util.*;
import ccmm.repository.*;
import ccmm.repository.impl.*;
import ccmm.repository.util.*;

import java.util.*;

import java.io.File;
import java.io.IOException;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import org.eclipse.emf.ecore.util.Diagnostician;

import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;



public class CCMMRepositoryTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

		//CREATION
		
		//get factories
		RepositoryFactory repositoryFactory = RepositoryFactory.eINSTANCE;
		BasicFactory basicFactory = BasicFactory.eINSTANCE;
		CoreFactory coreFactory = CoreFactory.eINSTANCE;
		ArchitectureFactory architectureFactory = ArchitectureFactory.eINSTANCE; 
		
		//create a repository
		Repository repository = repositoryFactory.createRepository();
		
		//create the required (simple) types and add them to repository
		Type intType = basicFactory.createType();
		intType.setName("int");
		repository.getTypes().add(intType);
		Type longType = basicFactory.createType();
		longType.setName("int");
		repository.getTypes().add(longType);
		Type StringType = basicFactory.createType();
		StringType.setName("String");
		repository.getTypes().add(StringType);
		Type DebitType = basicFactory.createType();
		DebitType.setName("Debit");
		repository.getTypes().add(DebitType);
		Type TransactionIDType = basicFactory.createType();
		TransactionIDType.setName("TransactionID");
		repository.getTypes().add(TransactionIDType);
		Type SaleTOType = basicFactory.createType();
		SaleTOType.setName("SaleTO");
		repository.getTypes().add(SaleTOType);
		Type ProductWithStockItemTOType = basicFactory.createType();
		ProductWithStockItemTOType.setName("ProductWithStockItemTOType");
		repository.getTypes().add(ProductWithStockItemTOType);
		
		//create the CashDeskConnectorIf interface type and add it to repository
		//1.create the bookSale operation
		Parameter saleTO = coreFactory.createParameter();
		saleTO.setName("saleTO");
		saleTO.setSort(ParameterSort.IN);
		saleTO.setType(SaleTOType);
		Operation bookSale = coreFactory.createOperation();
		bookSale.setName("bookSale");
		bookSale.getParameters().add(saleTO);
		//2.create the getProductWithStockItem operation
		Parameter productBarCode = coreFactory.createParameter();
		productBarCode.setName("productBarCode");
		productBarCode.setSort(ParameterSort.IN);
		productBarCode.setType(longType);
		Operation getProductWithStockItem = coreFactory.createOperation();
		getProductWithStockItem.setName("getProductWithStockItem");
		getProductWithStockItem.getParameters().add(productBarCode);
		getProductWithStockItem.setReturnType(ProductWithStockItemTOType);
		//3.create the CashDeskConnectorIf interface type owning the two above operations 
		//and add it to repository
		InterfaceType CashDeskConnectorIf = coreFactory.createInterfaceType();
		CashDeskConnectorIf.setName("CashDeskConnectorIf");
		CashDeskConnectorIf.getOperations().add(bookSale);
		CashDeskConnectorIf.getOperations().add(getProductWithStockItem);
		repository.getInterfaceTypes().add(CashDeskConnectorIf);
		
		//create BankIf interface type and add it to repository
		//1.create the validateCard operation
		Parameter cardInformation = coreFactory.createParameter();
		cardInformation.setName("cardInformation");
		cardInformation.setSort(ParameterSort.IN);
		cardInformation.setType(StringType);
		Parameter pinNumber = coreFactory.createParameter();
		pinNumber.setName("pinNumber");
		cardInformation.setSort(ParameterSort.IN);
		pinNumber.setType(intType);
		Operation validateCard = coreFactory.createOperation();
		validateCard.getParameters().add(cardInformation);
		validateCard.getParameters().add(pinNumber);
		validateCard.setReturnType(TransactionIDType);
		//2.create the debitCard operation
		Parameter id = coreFactory.createParameter();
		id.setName("id");
		id.setSort(ParameterSort.IN);
		id.setType(TransactionIDType);
		Operation debitCard = coreFactory.createOperation();
		debitCard.setName("debitCard");
		debitCard.getParameters().add(id);
		debitCard.setReturnType(DebitType);
		//3.create the BankIf interfaceType and add it to repository
		InterfaceType BankIf = coreFactory.createInterfaceType();
		BankIf.setName("BankIf");
		BankIf.getOperations().add(validateCard);
		BankIf.getOperations().add(debitCard);
		repository.getInterfaceTypes().add(BankIf);

		//create Bank component type and add it to repository
		//1.create the bankBankIf interface
		Interface bankBankIf = coreFactory.createInterface();
		bankBankIf.setName("bankBankIf");
		bankBankIf.setInterfaceType(BankIf);
		//2.create the Bank component type and add it to repository
		ComponentType Bank = coreFactory.createComponentType();
		Bank.setName("Bank");
		Bank.getProvidedInterfaces().add(bankBankIf);
		repository.getComponentTypes().add(Bank);
		
		
		//create the Inventory component type and add it to repository
		//1.create the inventoryCashDeskConnectorIf interface
		Interface inventoryCashDeskConnectorIf = coreFactory.createInterface();
		inventoryCashDeskConnectorIf.setName("inventoryCashDeskConnectorIf");
		inventoryCashDeskConnectorIf.setInterfaceType(CashDeskConnectorIf);
		//2.create the Inventory component type and add it to repository
		ComponentType Inventory = coreFactory.createComponentType();
		Inventory.setName("Inventory");
		Inventory.getProvidedInterfaces().add(inventoryCashDeskConnectorIf);
		repository.getComponentTypes().add(Inventory);
		
		//create the CashDeskLine component type and add it to repository
		//1.create the cashDeskLineCashDeskConnectorIf interface
		Interface cashDeskLineCashDeskConnectorIf = coreFactory.createInterface();
		cashDeskLineCashDeskConnectorIf.setName("cashDeskLineCashDeskConnectorIf");
		cashDeskLineCashDeskConnectorIf.setInterfaceType(CashDeskConnectorIf);
		//2.create the cashDeskLineBankIf interface
		Interface cashDeskLineBankIf = coreFactory.createInterface();
		cashDeskLineBankIf.setName("cashDeskLineBankIf");
		cashDeskLineBankIf.setInterfaceType(BankIf);
		//3.create the CashDeskLine componentType and add it to repository
		ComponentType CashDeskLine = coreFactory.createComponentType();
		CashDeskLine.setName("CashDeskLine");
		CashDeskLine.getRequiredInterfaces().add(cashDeskLineCashDeskConnectorIf);
		CashDeskLine.getRequiredInterfaces().add(cashDeskLineBankIf);
		repository.getComponentTypes().add(CashDeskLine);
		
		//create the composed TradingSystem component type and add it to repository
		//1.create the tradingSystemBankIf interface
		Interface tradingSystemBankIf = coreFactory.createInterface();
		tradingSystemBankIf.setName("tradingSystemBankIf");
		tradingSystemBankIf.setInterfaceType(BankIf);
		//2.create the TradingSystem component type
		ComponentType TradingSystem = coreFactory.createComponentType();
		TradingSystem.setName("TradingSystem");
		TradingSystem.getRequiredInterfaces().add(tradingSystemBankIf);
		//3.add it an architecture
		Architecture archTradingSystem = architectureFactory.createArchitecture();
		TradingSystem.setArchitecture(archTradingSystem);
		//4.create the components from within the architecture
		Component inventory = architectureFactory.createComponent();
		inventory.setName("inventory");
		inventory.setComponentType(Inventory);
		archTradingSystem.getComponents().add(inventory);
		Component cashDeskLine = architectureFactory.createComponent() ;
		cashDeskLine.setName("cashDeskLine");
		cashDeskLine.setComponentType(CashDeskLine);
		archTradingSystem.getComponents().add(cashDeskLine);
		//add, within the architecture of a component type, a subcomponent of the same type as the enclosing one
		/*Component wrongComponent = architectureFactory.createComponent();
		wrongComponent.setName("wrongComponent");
		wrongComponent.setComponentType(TradingSystem);
		archTradingSystem.getComponents().add(wrongComponent);*/
		//5.create the assembly binding between the above components and add it to the architecture
		AssemblyBinding bindCashDeskConnectorIf = architectureFactory.createAssemblyBinding();
		bindCashDeskConnectorIf.setFrom(cashDeskLineCashDeskConnectorIf);
		bindCashDeskConnectorIf.setTo(inventoryCashDeskConnectorIf);
		archTradingSystem.getBindings().add(bindCashDeskConnectorIf);
		//5'.create wrong assembly binding 
		AssemblyBinding wrongAssemblyBinding = architectureFactory.createAssemblyBinding();
		wrongAssemblyBinding.setFrom(cashDeskLineBankIf);
		wrongAssemblyBinding.setTo(bankBankIf);
		archTradingSystem.getBindings().add(wrongAssemblyBinding);
		//6.create the delegation binding and add it to the architecture
		DelegationBinding bindBankIf = architectureFactory.createDelegationBinding();
		bindBankIf.setFrom(cashDeskLineBankIf);
		bindBankIf.setTo(tradingSystemBankIf);
		archTradingSystem.getBindings().add(bindBankIf);
		repository.getComponentTypes().add(TradingSystem);
		
		//II.VALIDATION
		
		/*Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)repository);
		if (diagnostic.getSeverity() != Diagnostic.OK) {
			printDiagnostic(diagnostic, "");
		}
		else {
			System.out.println("Validation completed successfully!");
		}*/
	
		
		//III. OBSERVER EVALUATION
		
		List<EList<?>> cts; 
		ComponentType ct;
		cts = repository.getComponentTypesWithProvidedInterfaceType(BankIf);
		for(Iterator<EList<?>> it=cts.iterator();it.hasNext();)
		{
			ct = (ComponentType)it.next();
			System.out.println(ct.getName());
		}

	}

	protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
		System.out.print(indent);
		System.out.println(diagnostic.getMessage());
		for (Diagnostic child : diagnostic.getChildren()) {
			printDiagnostic(child, indent + "  ");
		}
	}

}
