/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.architecture;

import ccmm.basic.NamedElement;

import ccmm.core.ComponentType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Component</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link ccmm.architecture.Component#getArchitecture <em>Architecture</em>}</li>
 *   <li>{@link ccmm.architecture.Component#getComponentType <em>Component Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see ccmm.architecture.ArchitecturePackage#getComponent()
 * @model annotation="http://www.eclipse.org/emf/2002/Ecore constraints='distinctComponentNames'"
 *        annotation="http://www.eclipse.org/ocl/examples/OCL distinctComponentNames='self.architecture.components->select(c:Component | c.name = self.name)->size() = 1\r\n'"
 * @generated
 */
public interface Component extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Architecture</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link ccmm.architecture.Architecture#getComponents <em>Components</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Architecture</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Architecture</em>' container reference.
	 * @see #setArchitecture(Architecture)
	 * @see ccmm.architecture.ArchitecturePackage#getComponent_Architecture()
	 * @see ccmm.architecture.Architecture#getComponents
	 * @model opposite="components" required="true"
	 * @generated
	 */
	Architecture getArchitecture();

	/**
	 * Sets the value of the '{@link ccmm.architecture.Component#getArchitecture <em>Architecture</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Architecture</em>' container reference.
	 * @see #getArchitecture()
	 * @generated
	 */
	void setArchitecture(Architecture value);

	/**
	 * Returns the value of the '<em><b>Component Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Component Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Component Type</em>' reference.
	 * @see #setComponentType(ComponentType)
	 * @see ccmm.architecture.ArchitecturePackage#getComponent_ComponentType()
	 * @model required="true"
	 * @generated
	 */
	ComponentType getComponentType();

	/**
	 * Sets the value of the '{@link ccmm.architecture.Component#getComponentType <em>Component Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Component Type</em>' reference.
	 * @see #getComponentType()
	 * @generated
	 */
	void setComponentType(ComponentType value);

} // Component
