/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package ccmm.core;

import ccmm.basic.NamedElement;

import ccmm.interfacespecification.InformationModel;
import ccmm.interfacespecification.Invariant;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Interface</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link ccmm.core.Interface#getPComponentType <em>PComponent Type</em>}</li>
 *   <li>{@link ccmm.core.Interface#getRComponentType <em>RComponent Type</em>}</li>
 *   <li>{@link ccmm.core.Interface#getInterfaceType <em>Interface Type</em>}</li>
 *   <li>{@link ccmm.core.Interface#getInformationModel <em>Information Model</em>}</li>
 *   <li>{@link ccmm.core.Interface#getInvariant <em>Invariant</em>}</li>
 * </ul>
 * </p>
 *
 * @see ccmm.core.CorePackage#getInterface()
 * @model
 * @generated
 */
public interface Interface extends NamedElement {
	/**
	 * Returns the value of the '<em><b>PComponent Type</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link ccmm.core.ComponentType#getProvidedInterfaces <em>Provided Interfaces</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>PComponent Type</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>PComponent Type</em>' container reference.
	 * @see #setPComponentType(ComponentType)
	 * @see ccmm.core.CorePackage#getInterface_PComponentType()
	 * @see ccmm.core.ComponentType#getProvidedInterfaces
	 * @model opposite="providedInterfaces"
	 * @generated
	 */
	ComponentType getPComponentType();

	/**
	 * Sets the value of the '{@link ccmm.core.Interface#getPComponentType <em>PComponent Type</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>PComponent Type</em>' container reference.
	 * @see #getPComponentType()
	 * @generated
	 */
	void setPComponentType(ComponentType value);

	/**
	 * Returns the value of the '<em><b>RComponent Type</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link ccmm.core.ComponentType#getRequiredInterfaces <em>Required Interfaces</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RComponent Type</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RComponent Type</em>' container reference.
	 * @see #setRComponentType(ComponentType)
	 * @see ccmm.core.CorePackage#getInterface_RComponentType()
	 * @see ccmm.core.ComponentType#getRequiredInterfaces
	 * @model opposite="requiredInterfaces"
	 * @generated
	 */
	ComponentType getRComponentType();

	/**
	 * Sets the value of the '{@link ccmm.core.Interface#getRComponentType <em>RComponent Type</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>RComponent Type</em>' container reference.
	 * @see #getRComponentType()
	 * @generated
	 */
	void setRComponentType(ComponentType value);

	/**
	 * Returns the value of the '<em><b>Interface Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interface Type</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interface Type</em>' reference.
	 * @see #setInterfaceType(InterfaceType)
	 * @see ccmm.core.CorePackage#getInterface_InterfaceType()
	 * @model required="true"
	 * @generated
	 */
	InterfaceType getInterfaceType();

	/**
	 * Sets the value of the '{@link ccmm.core.Interface#getInterfaceType <em>Interface Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface Type</em>' reference.
	 * @see #getInterfaceType()
	 * @generated
	 */
	void setInterfaceType(InterfaceType value);

	/**
	 * Returns the value of the '<em><b>Information Model</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link ccmm.interfacespecification.InformationModel#getInterface <em>Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Information Model</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Information Model</em>' containment reference.
	 * @see #setInformationModel(InformationModel)
	 * @see ccmm.core.CorePackage#getInterface_InformationModel()
	 * @see ccmm.interfacespecification.InformationModel#getInterface
	 * @model opposite="interface" containment="true"
	 * @generated
	 */
	InformationModel getInformationModel();

	/**
	 * Sets the value of the '{@link ccmm.core.Interface#getInformationModel <em>Information Model</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Information Model</em>' containment reference.
	 * @see #getInformationModel()
	 * @generated
	 */
	void setInformationModel(InformationModel value);

	/**
	 * Returns the value of the '<em><b>Invariant</b></em>' containment reference list.
	 * The list contents are of type {@link ccmm.interfacespecification.Invariant}.
	 * It is bidirectional and its opposite is '{@link ccmm.interfacespecification.Invariant#getInterface <em>Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Invariant</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Invariant</em>' containment reference list.
	 * @see ccmm.core.CorePackage#getInterface_Invariant()
	 * @see ccmm.interfacespecification.Invariant#getInterface
	 * @model opposite="interface" containment="true"
	 * @generated
	 */
	EList<Invariant> getInvariant();

} // Interface
