
/*
 * @(#)Architecture.java
 *
 * Generated by <a href="http://lci.cs.ubbcluj.ro/ocle/>OCLE 2.0</a>
 * using <a href="http://jakarta.apache.org/velocity/">
 * Velocity Template Engine 1.3rc1</a>
 */
package CCMM.Architecture;
import CCMM.Core.ComponentType;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import ro.ubbcluj.lci.codegen.framework.ocl.BasicConstraintChecker;
import ro.ubbcluj.lci.codegen.framework.ocl.CollectionUtilities;

/**
 *
 * @author unascribed
 */
public class Architecture
{

    
    public final ComponentType getComponentType()
    {

        return componentType;
    }
    
    public final void setComponentType(ComponentType arg)
    {

        if (componentType != arg) {
            ComponentType temp = componentType;
            componentType = null;//to avoid infinite recursion
            if (temp != null) {
                temp.setArchitecture(null);
            }
            if (arg != null) {
                componentType = arg;
                arg.setArchitecture(this);
            }
        }

    }
    
    public final Set getComponents()
    {

        if (components == null) {
            return java.util.Collections.EMPTY_SET;
        }
        return java.util.Collections.unmodifiableSet(components);
    }
    
    public final void addComponents(Component arg)
    {

        if (arg != null) {
            if (components == null) {
                components = new LinkedHashSet();
            }
            if (components.add(arg)) {
                arg.setArchitecture(this);
            }
        }

    }
    
    public final void removeComponents(Component arg)
    {

        if (components != null && arg != null) {
            if (components.remove(arg)) {
                arg.setArchitecture(null);
            }
        }

    }
    
    public final Set getBindings()
    {

        if (bindings == null) {
            return java.util.Collections.EMPTY_SET;
        }
        return java.util.Collections.unmodifiableSet(bindings);
    }
    
    public final void addBindings(Binding arg)
    {

        if (arg != null) {
            if (bindings == null) {
                bindings = new LinkedHashSet();
            }
            if (bindings.add(arg)) {
                arg.setArchitecture(this);
            }
        }

    }
    
    public final void removeBindings(Binding arg)
    {

        if (bindings != null && arg != null) {
            if (bindings.remove(arg)) {
                arg.setArchitecture(null);
            }
        }

    }
    
    public Architecture()
    {

    }
    
    public class ConstraintChecker extends BasicConstraintChecker
    {

        
        public void checkConstraints()
        {

            super.checkConstraints();
            check_CCMM_Architecture_Architecture_invValidArchitecture();
            check_CCMM_Architecture_Architecture_invDistinctComponentNames();

        }
        
        public void check_CCMM_Architecture_Architecture_invValidArchitecture()
        {

            Set setComponents = Architecture.this.getComponents();
            //evaluate 'select(c|c.componentType=self.componentType)':
            Set setSelect = CollectionUtilities.newSet();
            final Iterator iter = setComponents.iterator();
            while (iter.hasNext())
            {
                final Component c = (Component)iter.next();
                ComponentType componentTypeComponentType = c.getComponentType();
                ComponentType componentTypeComponentType0 = Architecture.this.getComponentType();
                boolean bEquals = componentTypeComponentType.equals(componentTypeComponentType0);
                
                if (bEquals) CollectionUtilities.add(setSelect, c);
            }
            boolean bIsEmpty = CollectionUtilities.isEmpty(setSelect);
            if (!bIsEmpty)
            {
                System.err.println("invariant 'invValidArchitecture' failed for object "+Architecture.this);
            }

        }
        
        public void check_CCMM_Architecture_Architecture_invDistinctComponentNames()
        {

            Set setComponents = Architecture.this.getComponents();
            //evaluate 'isUnique(c|c.name)':
            Set uniquenessValidator = CollectionUtilities.newSet();
            boolean bIsUnique = true;
            final Iterator iter = setComponents.iterator();
            while (bIsUnique && iter.hasNext())
            {
                final Component c = (Component)iter.next();
                String strName = c.name;
                
                bIsUnique = uniquenessValidator.add(strName);
            }
            if (!bIsUnique)
            {
                System.err.println("invariant 'invDistinctComponentNames' failed for object "+Architecture.this);
            }

        }

    }
    
    public ComponentType componentType;
    
    public Set components;
    
    public Set bindings;

}
