package test;

import CCMM.Basic.*;
import CCMM.Core.*;
import CCMM.Architecture.*;
import CCMM.Repository.*;

public class CCMMRepositoryTest {

	public static void main(String[] args) {
		
		//I.CREATION
		
		//CREATE THE REQUIRED (SIMPLE) TYPES	
		Type intType = new Type();
		intType.name = "int";
		Type longType = new Type();
		longType.name = "long";
		Type StringType = new Type();
		StringType.name = "String";
		Type TransactionIDType = new Type();
		TransactionIDType.name = "TransactionID";
		Type DebitType = new Type();
		DebitType.name = "Debit";
		Type SaleTOType = new Type();
		SaleTOType.name = "SaleTO";
		Type ProductWithStockItemTOType = new Type();
		ProductWithStockItemTOType.name = "ProductWithStockItemTO";
				
		//CREATE THE CashDeskConnectorIf INTERFACE TYPE
		//1.create the bookSale operation
		Parameter saleTO = new Parameter();
		saleTO.name = "saleTO";
		saleTO.sort = ParameterSort.in;
		saleTO.setType(SaleTOType);
		Operation bookSale = new Operation();
		bookSale.name = "bookSale";
		bookSale.addParameters(saleTO);
		//2.create the getProductWithStockItem operation
		Parameter productBarCode = new Parameter();
		productBarCode.name = "productBarCode";
		productBarCode.sort = ParameterSort.in;
		productBarCode.setType(longType);
		Operation getProductWithStockItem = new Operation();
		getProductWithStockItem.name = "getProductWithStockItem";
		getProductWithStockItem.addParameters(productBarCode);
		getProductWithStockItem.setReturnType(ProductWithStockItemTOType);
		//3.create the CashDeskConnectorIf interface type owning the two above defined operations
		InterfaceType CashDeskConnectorIf = new InterfaceType();
		CashDeskConnectorIf.name = "CashDeskConnectorIf";
		CashDeskConnectorIf.addOperations(bookSale);
		CashDeskConnectorIf.addOperations(getProductWithStockItem);
		
		//CREATE THE BankIf INTERFACE TYPE
		//1.create the validateCard operation
		Parameter cardInformation = new Parameter();
		cardInformation.name = "cardInformation";
		cardInformation.sort = ParameterSort.in;
		cardInformation.setType(StringType);
		Parameter pinNumber = new Parameter();
		pinNumber.name = "pinNumber";
		cardInformation.sort = ParameterSort.in;
		pinNumber.setType(intType);
		Operation validateCard = new Operation();
		validateCard.addParameters(cardInformation);
		validateCard.addParameters(pinNumber);
		validateCard.setReturnType(TransactionIDType);
		//2.create the debitCard operation
		Parameter id = new Parameter();
		id.name = "id";
		id.sort = ParameterSort.in;
		id.setType(TransactionIDType);
		Operation debitCard = new Operation();
		debitCard.name = "debitCard";
		debitCard.addParameters(id);
		debitCard.setReturnType(DebitType);
		//3.create the BankIf interfaceType
		InterfaceType BankIf = new InterfaceType();
		BankIf.name = "BankIf";
		BankIf.addOperations(validateCard);
		BankIf.addOperations(debitCard);
		
		//CREATE THE Bank COMPONENT TYPE
		//1.create the bankBankIf interface
		Interface bankBankIf = new Interface();
		bankBankIf.name = "bankBankIf";
		bankBankIf.setInterfaceType(BankIf);
		//2.create the Bank component type
		ComponentType Bank = new ComponentType();
		Bank.name = "Bank";
		Bank.addProvidedInterfaces(bankBankIf);
		
		//CREATE THE Inventory COMPONENT TYPE
		//1.create the inventoryCashDeskConnectorIf interface
		Interface inventoryCashDeskConnectorIf = new Interface();
		inventoryCashDeskConnectorIf.name = "inventoryCashDeskConnectorIf";
		inventoryCashDeskConnectorIf.setInterfaceType(CashDeskConnectorIf);
		//2.create the Inventory component type
		ComponentType Inventory = new ComponentType();
		Inventory.name = "Inventory";
		Inventory.addProvidedInterfaces(inventoryCashDeskConnectorIf);
		
		//CREATE THE CashDeskLine COMPONENT TYPE
		//1.create the cashDeskLineCashDeskConnectorIf interface
		Interface cashDeskLineCashDeskConnectorIf = new Interface();
		cashDeskLineCashDeskConnectorIf.name = "cashDeskLineCashDeskConnectorIf";
		cashDeskLineCashDeskConnectorIf.setInterfaceType(CashDeskConnectorIf);
		//2.create the cashDeskLineBankIf interface
		Interface cashDeskLineBankIf = new Interface();
		cashDeskLineBankIf.name = "cashDeskLineBankIf";
		cashDeskLineBankIf.setInterfaceType(BankIf);
		//3.create the CashDeskLine componentType 
		ComponentType CashDeskLine = new ComponentType();
		CashDeskLine.name = "CashDeskLine";
		CashDeskLine.addRequiredInterfaces(cashDeskLineCashDeskConnectorIf);
		CashDeskLine.addRequiredInterfaces(cashDeskLineBankIf);
		
		//CREATE THE COMPOSED TradingSystem COMPONENT TYPE
		//1.create the tradingSystemBankIf interface
		Interface tradingSystemBankIf = new Interface();
		tradingSystemBankIf.name = "tradingSystemBankIf";
		tradingSystemBankIf.setInterfaceType(BankIf);
		//2.create the TradingSystem component type
		ComponentType TradingSystem = new ComponentType();
		TradingSystem.name = "TradingSystem";
		TradingSystem.addRequiredInterfaces(tradingSystemBankIf);
		//3.add it an architecture
		Architecture archTradingSystem = new Architecture();
		TradingSystem.setArchitecture(archTradingSystem);
		//4.create the components from within the architecture
		Component inventory = new Component();
		inventory.setComponentType(Inventory);
		Component cashDeskLine = new Component();
		cashDeskLine.setComponentType(CashDeskLine);
		archTradingSystem.addComponents(inventory);
		archTradingSystem.addComponents(cashDeskLine);
		//5.create the assembly binding between the above components and add it to the architecture
		AssemblyBinding bindCashDeskConnectorIf = new AssemblyBinding();
		bindCashDeskConnectorIf.setFrom(cashDeskLineCashDeskConnectorIf);
		bindCashDeskConnectorIf.setTo(inventoryCashDeskConnectorIf);
		archTradingSystem.addBindings(bindCashDeskConnectorIf);
		//6.create the delegation binding and add it to the architecture
		DelegationBinding bindBankIf = new DelegationBinding();
		bindBankIf.setFrom(cashDeskLineBankIf);
		bindBankIf.setTo(tradingSystemBankIf);
		archTradingSystem.addBindings(bindBankIf);
		
		
		//II.VALIDATION
		//in order to validate of the two previously created bindings, uncomment 1 and 2 (no console output = OK)
		//in order to illustrate illegal bindings, uncomment 3 or 4 (see console output)
		//in order to illustrate interface name clashes inside a component type uncomment 6
		
		//1.validate the legal bindCashConnectorIf assembly binding 
		AssemblyBinding.ConstraintChecker bindCashConnectorIfChecker =  bindCashDeskConnectorIf.new ConstraintChecker();
		bindCashConnectorIfChecker.checkConstraints();
		javax.swing.JOptionPane.showMessageDialog(null,"Legal bindCashConnectorIf assembly binding!");
		
		//2.validate the legal bindBankIf delegation binding
		DelegationBinding.ConstraintChecker bindBankIfChecker = bindBankIf.new ConstraintChecker();
		bindBankIfChecker.checkConstraints();
		javax.swing.JOptionPane.showMessageDialog(null,"Legal bindBankIf delegation binding!");
		
		//3.create wrong binding (the connected interfaces don't have the same type) and check it
		AssemblyBinding wrongBinding = new AssemblyBinding();
		wrongBinding.setFrom(cashDeskLineBankIf);
		wrongBinding.setTo(inventoryCashDeskConnectorIf);
		archTradingSystem.addBindings(wrongBinding);
		
		Binding.ConstraintChecker wrongBindingChecker =  wrongBinding.new ConstraintChecker();
		wrongBindingChecker.checkConstraints();
		javax.swing.JOptionPane.showMessageDialog(null,"Wrong binding!");
		
		//4.create wrong assembly binding (the target (to role) is from outside the current architecture) and check it
		/*AssemblyBinding wrongAssemblyBinding = new AssemblyBinding();
		wrongAssemblyBinding.setFrom(cashDeskLineBankIf);
		wrongAssemblyBinding.setTo(bankBankIf);
		archTradingSystem.addBindings(wrongAssemblyBinding);
		
		AssemblyBinding.ConstraintChecker wrongAssemblyBindingChecker = wrongAssemblyBinding.new ConstraintChecker();
		wrongAssemblyBindingChecker.checkConstraints();
		javax.swing.JOptionPane.showMessageDialog(null,"Wrong binding!");*/
		
		//5.create wrong delegation binding () and check it
		//no meaningful example found in this case:(
		
		//6.change the name of an interface, so as to have two interfaces with the same name provided by the same component type and check
		/*cashDeskLineBankIf.name = "cashDeskLineCashDeskConnectorIf";
		ComponentType.ConstraintChecker interfaceNameClashChecker = CashDeskLine.new ConstraintChecker();
		interfaceNameClashChecker.check_CCMM_Core_ComponentType_invDistinctInterfaceNames();*/
		
		
	}

}
