/*
 * Decompiled with CFR 0.152.
 */
package econet;

import econet.Decision;
import econet.Interface;
import econet.MyIType;
import java.util.Collection;
import org.eclipse.jdt.core.dom.IMethodBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Information {
    private Decision data = new Decision();
    private boolean root = false;
    private MyIType ibind = new MyIType();
    private boolean viewed = false;
    private boolean cycle = false;
    private Interface requiredinterface;
    private Interface providedInterface;

    public Information() {
    }

    public Information(boolean r) {
        this();
        this.root = true;
    }

    public String toString() {
        String result = "";
        result = this.data.isDataType() ? " Data type " : (this.data.isComponentType() ? " Component type " : " undefined ");
        if (this.root) {
            result = String.valueOf(result) + " ROOT ";
        }
        if (this.ibind != null) {
            result = String.valueOf(result) + " binding " + this.ibind;
        }
        return String.valueOf(result) + " VIEWED=" + this.viewed + " CYCLE=" + this.cycle;
    }

    public void setDataType(boolean data) {
        if (data) {
            this.data = new Decision(Decision.Values.DATA);
        }
    }

    public void setComponentType(boolean data) {
        if (data) {
            this.data = new Decision(Decision.Values.COMP);
        }
    }

    public void setType(MyIType it) {
        this.ibind = it;
    }

    public void setRoot() {
        this.root = true;
    }

    public boolean isResolved() {
        return this.ibind.isResolved();
    }

    public boolean hasFields() {
        return this.ibind.hasFields();
    }

    public boolean isDataType() {
        return this.data.isDataType();
    }

    public boolean isComponentType() {
        return this.data.isComponentType();
    }

    public MyIType getIbind() {
        return this.ibind;
    }

    public boolean isViewed() {
        return this.viewed;
    }

    public void setViewed(boolean viewed) {
        this.viewed = viewed;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    public Interface getRequiredInterface() throws Exception {
        if (this.data.isComponentType()) {
            return this.requiredinterface;
        }
        throw new Exception("error : Information.getRequiredInterface : " + this.ibind.getFullName() + " is not a component");
    }

    public void setRequiredInterface(Interface requiredInterface) throws Exception {
        if (!this.data.isComponentType()) {
            throw new Exception("error : Information.setRequiredInterface : " + this.ibind.getFullName() + " is not a component");
        }
        this.requiredinterface = requiredInterface;
    }

    public Interface getProvidedInterface() throws Exception {
        if (this.data.isComponentType()) {
            return this.providedInterface;
        }
        throw new Exception("error : Information.getProvidedInterface : " + this.ibind.getFullName() + " is not a component");
    }

    public void setProvidedInterface(Interface providedInterface) throws Exception {
        if (!this.data.isComponentType()) {
            throw new Exception("error : Information.setProvidedInterface : " + this.ibind.getFullName() + " is not a component");
        }
        this.providedInterface = providedInterface;
    }

    public void addProvidedMethod(IMethodBinding method) throws Exception {
        if (!this.data.isComponentType()) {
            throw new Exception("error : Information.addProvidedMethod : " + this.ibind.getFullName() + " is not a component");
        }
        this.providedInterface.addMethod(method);
    }

    public void addRequiredMethod(IMethodBinding method) throws Exception {
        if (!this.data.isComponentType()) {
            throw new Exception("error : Information.addRequiredMethod : " + this.ibind.getFullName() + " is not a component");
        }
        this.requiredinterface.addMethod(method);
    }

    public void addProvidedMethods(Collection<IMethodBinding> methods) throws Exception {
        if (!this.data.isComponentType()) {
            throw new Exception("error : Information.addProvidedMethod : " + this.ibind.getFullName() + " is not a component");
        }
        this.providedInterface.addMethods(methods);
    }

    public void addRequiredMethods(Collection<IMethodBinding> methods) throws Exception {
        if (!this.data.isComponentType()) {
            throw new Exception("error : Information.addRequiredMethod : " + this.ibind.getFullName() + " is not a component");
        }
        this.requiredinterface.addMethods(methods);
    }
}

