/*
 * Decompiled with CFR 0.152.
 */
package econet;

import econet.Fields;
import econet.Information;
import econet.Interface;
import econet.MyIType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesTable
extends HashMap<String, Information> {
    private static final long serialVersionUID = 1L;

    public TypesTable(Vector<IType> vt) {
        int i = 0;
        while (i < vt.size()) {
            this.put(vt.get(i).getFullyQualifiedName(), new Information());
            ++i;
        }
    }

    public boolean isOfInterest(String fn) {
        return this.containsKey(fn);
    }

    public boolean isDataType(String fn) {
        return ((Information)this.get(fn)).isDataType();
    }

    public boolean isResolved(String fn) {
        return ((Information)this.get(fn)).isResolved();
    }

    public boolean hasFields(String fn) {
        return ((Information)this.get(fn)).hasFields();
    }

    public void setDataType(String bn) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setDataType(true);
            this.put(bn, inf);
            this.propagateDATA();
        }
    }

    public void setComponentType(String bn) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setComponentType(true);
            if (inf.isDataType()) {
                this.put(bn, inf);
                this.propagateDATA();
            }
        }
    }

    public void setRoot(String bn) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setRoot();
            this.put(bn, inf);
        }
    }

    public void addType(String fn, Information it) {
        this.put(fn, it);
    }

    public void setType(String bn, MyIType it) {
        if (this.containsKey(bn)) {
            Information inf = (Information)this.get(bn);
            inf.setType(it);
            this.put(bn, inf);
        }
    }

    public boolean inheritsFromData(String sub, String sup) {
        boolean result = false;
        if (!sub.equals(sup) && this.isOfInterest(sub)) {
            String thesup;
            result = !this.isOfInterest(sup) ? true : (thesup = ((Information)this.get(sub)).getIbind().getSupername()).equals(sup) || this.inheritsFromData(thesup, sup);
        }
        return result;
    }

    public void propagateDATA() {
        for (String key : this.keySet()) {
            if (((Information)this.get(key)).isDataType()) {
                for (String subc : ((Information)this.get(key)).getIbind().getSubclasses()) {
                    ((Information)this.get(subc)).setDataType(true);
                }
                continue;
            }
            if (!((Information)this.get(key)).isComponentType()) continue;
            for (String subc : ((Information)this.get(key)).getIbind().getSubclasses()) {
                ((Information)this.get(subc)).setComponentType(true);
            }
        }
    }

    public Vector<String> checkPublicFields() {
        Vector<String> res = new Vector<String>();
        for (String key : this.keySet()) {
            if (!((Information)this.get(key)).isComponentType() || !((Information)this.get(key)).getIbind().hasPublicFields()) continue;
            res.add(key);
        }
        return res;
    }

    public Vector<String> checkCycle() {
        for (String key : this.keySet()) {
            if (((Information)this.get(key)).isComponentType()) continue;
            ((Information)this.get(key)).setViewed(true);
        }
        Vector<String> res = new Vector<String>();
        for (String key : this.keySet()) {
            if (((Information)this.get(key)).isViewed()) continue;
            res.addAll(this.findCycle(key, new Vector<String>()));
        }
        return res;
    }

    public Vector<String> findCycle(String node, Vector<String> history) {
        Vector<String> res = new Vector<String>();
        Information info = (Information)this.get(node);
        if (history.contains(node)) {
            res.add(node);
            info.setCycle(true);
        } else {
            for (IVariableBinding f : info.getIbind().getStructure()) {
                String fname = f.getType().getQualifiedName();
                Information inff = (Information)this.get(fname);
                if (inff.isViewed()) {
                    if (!inff.isCycle()) continue;
                    if (!res.contains(node)) {
                        res.add(node);
                    }
                    info.setCycle(true);
                    continue;
                }
                history.add(node);
                for (String st : this.findCycle(fname, history)) {
                    if (res.contains(st)) continue;
                    res.add(st);
                }
            }
        }
        info.setViewed(true);
        return res;
    }

    public void setType(String bn) {
        this.put(bn, new Information());
    }

    public Fields getStructure(String fullname) {
        return ((Information)this.get(fullname)).getIbind().getStructure();
    }

    @Override
    public String toString() {
        String result = "";
        for (String key : this.keySet()) {
            result = String.valueOf(result) + key + " -> " + this.get(key) + "\n";
        }
        return result;
    }

    public boolean isComponentType(String fn) {
        return ((Information)this.get(fn)).isComponentType();
    }

    public void addProvidedMethod(String fn, IMethodBinding method) throws Exception {
        ((Information)this.get(fn)).addProvidedMethod(method);
    }

    public void addRequiredMethod(String fn, IMethodBinding method) throws Exception {
        ((Information)this.get(fn)).addRequiredMethod(method);
    }

    public void addProvidedMethods(String fn, Collection<IMethodBinding> methods) throws Exception {
        ((Information)this.get(fn)).addProvidedMethods(methods);
    }

    public void addRequiredMethods(String fn, Collection<IMethodBinding> methods) throws Exception {
        ((Information)this.get(fn)).addRequiredMethods(methods);
    }

    public Interface getRequiredInterface(String fn) throws Exception {
        return ((Information)this.get(fn)).getRequiredInterface();
    }

    public Interface getProvidedInterface(String fn) throws Exception {
        return ((Information)this.get(fn)).getProvidedInterface();
    }

    public void setRequiredInterface(String fn, Interface requiredInterface) throws Exception {
        ((Information)this.get(fn)).setRequiredInterface(requiredInterface);
    }

    public void setProvidedInterface(String fn, Interface requiredInterface) throws Exception {
        ((Information)this.get(fn)).setProvidedInterface(requiredInterface);
    }
}

