/*
 * Decompiled with CFR 0.152.
 */
package rules;

import econet.ASTActionDelegate;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import rules.SimpleRule;

public class FlagFromAttributesVisibility
extends SimpleRule {
    private final String name = "FlagFromAttributesVisibility";
    private double threshold = 0.7;

    public FlagFromAttributesVisibility(ASTActionDelegate astAD) {
        super(astAD);
    }

    public String getName() {
        return "FlagFromAttributesVisibility";
    }

    public void run() {
        try {
            ASTActionDelegate.getInstance();
            for (IType it : ASTActionDelegate.getTypesOfInterest()) {
                int nbPublicFields;
                int nbFields;
                if (it.isInterface() || (nbFields = it.getFields().length) == 0 || !((double)((nbPublicFields = this.getPublicFieldsNumber(it)) / nbFields) >= this.threshold)) continue;
                ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private int getPublicFieldsNumber(IType it) {
        int nbPublicFields = 0;
        try {
            IField[] iFieldArray = it.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField ifield = iFieldArray[n2];
                int fieldFlags = ifield.getFlags();
                if (Flags.isPublic((int)fieldFlags)) {
                    ++nbPublicFields;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return nbPublicFields;
    }
}

