/*
 * Decompiled with CFR 0.152.
 */
package rules;

import econet.ASTActionDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import rules.SimpleRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlagFromGettersAndSetters
extends SimpleRule {
    private final String name = "FlagFromGettersAndSetters";
    private double threshold = 0.7;

    public FlagFromGettersAndSetters(ASTActionDelegate astAD) {
        super(astAD);
    }

    public String getName() {
        return "FlagFromGettersAndSetters";
    }

    @Override
    public void run() {
        for (IType it : ASTActionDelegate.getTypesOfInterest()) {
            try {
                int nbFields;
                if (it.isInterface() || (nbFields = it.getFields().length) == 0) continue;
                List<String> methodsName = this.getGettersAndSettersName(it);
                List<String> fieldsName = this.getFieldsName(it);
                HashMap<String, Boolean> hasGetterOrSetter = new HashMap<String, Boolean>();
                for (String fieldName : fieldsName) {
                    hasGetterOrSetter.put(fieldName, false);
                    for (String methodName : methodsName) {
                        if (!(methodName.endsWith(fieldName) | methodName.endsWith("All" + fieldName))) continue;
                        hasGetterOrSetter.put(fieldName, true);
                    }
                }
                int nbFieldsWithGetterOrSetter = 0;
                for (String fieldName : fieldsName) {
                    Boolean fieldNameKey = (Boolean)hasGetterOrSetter.get(fieldName);
                    if (!fieldNameKey.booleanValue()) continue;
                    ++nbFieldsWithGetterOrSetter;
                }
                if (!((double)(nbFieldsWithGetterOrSetter / nbFields) >= this.threshold)) continue;
                ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getGettersAndSettersName(IType it) throws JavaModelException {
        ArrayList<String> gettersAndSetters = new ArrayList<String>();
        IMethod[] iMethodArray = it.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod im = iMethodArray[n2];
            String imName = im.getElementName();
            if (imName.startsWith("get") | imName.startsWith("set")) {
                gettersAndSetters.add(imName);
            }
            ++n2;
        }
        return gettersAndSetters;
    }

    public List<String> getFieldsName(IType it) throws JavaModelException {
        ArrayList<String> fieldsName = new ArrayList<String>();
        IField[] iFieldArray = it.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            String fieldName = field.getElementName();
            fieldsName.add(fieldName.substring(0, 1).toUpperCase().concat(fieldName.substring(1, fieldName.length())));
            ++n2;
        }
        return fieldsName;
    }
}

