/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import econet.ASTActionDelegate;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import wizard.EconetWizard;
import wizard.RuleWizard;

public class LoadWizard
extends WizardPage
implements Listener {
    IWorkbench workbench;
    IStructuredSelection selection;
    Button projectButton;
    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    IPath location = this.root.getLocation();
    String fileFilterPath = this.location.toString();
    IProject project;
    IJavaProject javaProject;
    Text containerText;
    Button buttonSelectDir;
    String selectedDir;
    Boolean nextPage = false;
    Label label;

    public LoadWizard(IWorkbench workbench, IStructuredSelection selection) {
        super("Page1");
        this.setTitle("Your Project");
        this.setDescription("Select a Java project in workspace");
        this.workbench = workbench;
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        int ncol;
        final Composite container = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 4;
        container.setLayout((Layout)gl);
        this.label = new Label(container, 0);
        this.label.setText("Project:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.buttonSelectDir = new Button(container, 8);
        this.buttonSelectDir.setText("Browse...");
        this.buttonSelectDir.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(container.getShell());
                directoryDialog.setFilterPath(LoadWizard.this.fileFilterPath);
                directoryDialog.setMessage("Please select a directory and click OK");
                String dir = directoryDialog.open();
                if (dir != null) {
                    LoadWizard.this.containerText.setText(LoadWizard.getFileName(dir));
                    LoadWizard.this.selectedDir = dir;
                    this.availableProject();
                }
            }

            public void availableProject() {
                LoadWizard.this.project = LoadWizard.this.root.getProject(LoadWizard.this.containerText.getText());
                LoadWizard.this.javaProject = JavaCore.create((IProject)LoadWizard.this.project);
                if (LoadWizard.this.javaProject != null) {
                    ASTActionDelegate.getInstance().setJavaProject(LoadWizard.this.javaProject);
                    ASTActionDelegate.getInstance().setProjectName(LoadWizard.this.containerText.getText());
                    LoadWizard.this.nextPage = true;
                    LoadWizard.this.getWizard().getContainer().updateButtons();
                } else {
                    System.out.println("not projet java");
                    MessageDialog.openError((Shell)LoadWizard.this.getShell(), (String)"No project", (String)LoadWizard.this.containerText.getText());
                }
            }
        });
        this.setControl((Control)container);
    }

    public boolean canFlipToNextPage() {
        return this.nextPage != false;
    }

    public boolean canFinish() {
        return false;
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        RuleWizard page = null;
        page = ((EconetWizard)this.getWizard()).rulePage;
        return page;
    }

    public static String getFileName(String path) {
        String fileName = null;
        String separator = File.separator;
        int pos = path.lastIndexOf(separator);
        int pos2 = path.lastIndexOf(".");
        fileName = pos2 > -1 ? path.substring(pos + 1, pos2) : path.substring(pos + 1);
        return fileName;
    }
}

