package annotation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.Vector;
import java.util.Map.Entry;


import org.eclipse.core.resources.IProject;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.IMethodBinding;

import econet.ASTActionDelegate;
import econet.Information;

public class AnnotationEconet {

	private String root_project_string;
	private String separator;
	
	public AnnotationEconet(ASTActionDelegate ast) throws Exception {
		
		// in this block we get the current directory of the project
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IProject tes = root.getProject(ast.getProjectName());
		File repository = tes.getLocation().toFile();
		// then we are making a string with the system separator and the root
		separator = System.getProperty("file.separator");
		root_project_string = repository.getPath()+separator;
		
		
		// there when we have all basics elements we do each of the method to make the annotations
		// we have put the method doComposite at the last position as we think we need previous informations about
		// doComponent before doing the modification for the composites.
		doComponent(ast);
		//doProvided(ast);
		//doRequired(ast);
		doComposite(ast);
	}
	
	private void doComposite(ASTActionDelegate ast) throws Exception{
		// TODO 
		
		
		// composite structure may be in the structure attribute of the ASTActionDelegate
		Iterator<Entry<String, String>> it = ast.getStructure().entrySet().iterator();
		
		while(it.hasNext()){
			Entry<String, String> current = it.next();
			
			//In this method we will use informations about composite structure in order to modify 
			//the annotations of each component we have previously made to match what we have in the 
			// "componentName" part of the annotation InComponent(annotationSrc,Name)
			// it will modify each component find, with the name of his composite instead of his current name
		}
	}

	@Deprecated
	private void doProvided(ASTActionDelegate ast) throws Exception{
		//we must get information about the provided interface
		// this method must be modified in order to modify the interface, not the method in components
		
		Iterator<Entry<String,Information>> it = ast.getTable().entrySet().iterator();//ast.provided.entrySet().iterator();
		
		while(it.hasNext()){
			Entry<String,Information> current = it.next();
			
			// we do the string for the directory of the element
			// as like CoCoME we have org.cocome... in order to get a string like org/CoCoME/... (if we are on linux
			// otherwise it should be org\CoCoME\...
			
			
			
			
			
			String[] rep = current.getKey().split("[.]");
		
			String directory = "";
			for (int i=0;i<rep.length-1;i++){
				// we append to the name the file separator of the system
				directory+= rep[i]+System.getProperty("file.separator");
			}
			
			// we are making the file we must modify
			// in entree you will have the source file
			// in rep_sortie you will have the directory of the new file which we will create
			// in sortie you have the new file created
			File entree = new File(root_project_string+"src"+separator+directory+separator+rep[rep.length-1]+".java");
			File rep_sortie = new File(root_project_string+"news"+separator+directory+separator);
			if (rep_sortie.exists() == false){
				rep_sortie.mkdirs();
			}
			File sortie=new File(root_project_string+"news"+separator+directory+separator+rep[rep.length-1]+".java");
			//we check if the file is already existing in order to avoid modifying it if it were not a proper file
			// for example an error in the rules
			if (sortie.exists() == false){
				sortie.setWritable(true);
				sortie.createNewFile();
				
				
				// we are making the buffer to read and write the files
				BufferedReader br = new BufferedReader(new FileReader(entree));
				BufferedWriter bw = new BufferedWriter(new FileWriter(sortie));
				String ligne="";
				 
				while ((ligne = br.readLine()) != null){
					// if the file begins with public interface then we are sure its an interface
					// and as we are in the doProvided method, we only check the provided interface
					// we have get in the provided attribute of the AST
					if(ligne.startsWith("public interface")){
						bw.write("@Provided(annotationSrc={\"plug-in ECONET\",\"doProvided\"},modelIfaceName={\""+ rep[rep.length-1] +"\"})\n");
						bw.write(ligne+"\n");
						bw.flush();
						// if it does not contains the line then we simply copy the line
					}else{
						bw.write(ligne+"\n");
						bw.flush();
					}
				}
				// we close the buffer
				bw.close();
				br.close();
			}
		}
	}

	private void doRequired(ASTActionDelegate ast) throws Exception{
		//we must get information about the required interface
		//we need the rule which flag required interface to be implemented in order to know the structure
		// this rule would have been for the Interface not for the methods
		/*
		 
		TODO modify implement with structure of required 
		
		Iterator<Entry<String,Vector<IMethod>>> it = ast.required.entrySet().iterator();
		ast.view.append("\n");
		ast.view.append("//////////////////////////////////////////////////////////////////\n");
		ast.view.append("////////////// modification for required Interface ///////////////\n");
		ast.view.append("//////////////////////////////////////////////////////////////////\n");
		while(it.hasNext()){
			Entry<String,Vector<IMethod>> current = it.next();
				
				String[] rep = current.getKey().split("[.]");
				ast.view.append(current.getKey()+"\n");
				String repertoire = "";
				for (int i=0;i<rep.length-1;i++){
						repertoire+= rep[i]+System.getProperty("file.separator");
				}
				ast.view.append(repertoire+"\n");
				File entree = new File(racine+"src"+separateur+repertoire+separateur+rep[rep.length-1]+".java");
				File rep_sortie = new File(racine+"news"+separateur+repertoire+separateur);
				if (rep_sortie.exists() == false){
					rep_sortie.mkdirs();
				}
				File sortie=new File(racine+"news"+separateur+repertoire+separateur+rep[rep.length-1]+".java");
				if (sortie.exists() == false){
					sortie.setWritable(true);
					sortie.createNewFile();
					
					
					
					BufferedReader br = new BufferedReader(new FileReader(entree));
					BufferedWriter bw = new BufferedWriter(new FileWriter(sortie));
					String ligne="";
					 
					while ((ligne = br.readLine()) != null){
						if(ligne.startsWith("public interface")){
							bw.write("@Required(annotationSrc={\"plug-in ECONET\",\"doRequired\"},modelIfaceName={\""+ rep[rep.length-1] +"\"})\n");
							bw.write(ligne+"\n");
							bw.flush();
						}else{
							bw.write(ligne+"\n");
							bw.flush();
						}
					}
					bw.close();
					br.close();
				}
			}
			
			*/
	}
	
	public void doComponent(ASTActionDelegate ast) throws Exception{
		
		
		//we get the table where the component and DataType are
		Iterator<Entry<String,Information>> it = ast.getTable().entrySet().iterator();
		
		while(it.hasNext()){
			Entry<String,Information> current = it.next();
			
			// we check if the current element is a component
			
				
				
			//Like the other method we get the directory 
			String[] rep = current.getKey().split("[.]");
			String directory = "";
			for (int i=0;i<rep.length-1;i++){
					directory+= rep[i]+separator;
			}
			// we create the files
			File entree = new File(root_project_string+"src"+separator+directory+separator+rep[rep.length-1]+".java");
			File rep_sortie = new File(root_project_string+"news"+separator+directory+separator);
			if (rep_sortie.exists() == false){
				rep_sortie.mkdirs();
			}
			File sortie=new File(root_project_string+"news"+separator+directory+separator+rep[rep.length-1]+".java");
			sortie.delete();
			sortie.setWritable(true);
			sortie.createNewFile();
			
			
			// we create the buffer
			BufferedReader br = new BufferedReader(new FileReader(entree));
			BufferedWriter bw = new BufferedWriter(new FileWriter(sortie));
			String ligne="";
			
			
			while ((ligne = br.readLine()) != null){
				// we modify if we have a matching with "class Name"
				// so that we are sure it is the first line of this class
				// ans that we need to modify it
				if(current.getValue().isComponentType()){
					if(ligne.contains("class "+rep[rep.length-1])){
						bw.write("@InComponent(annotationSrc={\"plug-in ECONET\",\"doComponent\"},componentName={\""+ current.getKey() +"\"})\n");
						bw.write(ligne+"\n");
						bw.flush();
					}else{
						// we also check if there is a Constructor in the file
						// as it is similar to Name(... 
						if(ligne.contains("public "+ rep[rep.length-1]+"(")){
							bw.write("@InitMethod(annotationSrc={\"plug-in ECONET\",\"doComponent\"},componentName{\""+ current.getKey() + "\"})\n");
							bw.write(ligne+"\n");
							bw.flush();
						}
						else{
							provided(current, bw, ligne);
							required(current, bw, ligne);
							bw.write(ligne+"\n");
							bw.flush();
						}
					}
				}
				else{
					bw.write(ligne+"\n");
					bw.flush();
				}
			}
				
			bw.close();
			br.close();
			}
	}
	
	public void provided(Entry<String, Information> current, BufferedWriter bw,String ligne) throws Exception{
		if (current.getValue().getProvidedInterface() != null){
			if (current.getValue().getProvidedInterface().getMethods() != null){
				Iterator<IMethodBinding> it_meth_pro = current.getValue().getProvidedInterface().getMethods().iterator();
				while(it_meth_pro.hasNext()){
					IMethodBinding inter = it_meth_pro.next();
					if (ligne.contains(inter.getName())){
						System.out.println(current.getKey());
						bw.write("@ProvidedMethod(annotationSrc={\"plug-in ECONET\",\"doComponent\"},componentName{\""+ current.getKey() + "\"})\n");
					}
				}
			}
		}
	}
	public void required(Entry<String, Information> current, BufferedWriter bw,String ligne) throws Exception{
		if (current.getValue().getRequiredInterface() != null){
			if (current.getValue().getRequiredInterface().getMethods() != null){
				Iterator<IMethodBinding> it_meth_req = current.getValue().getRequiredInterface().getMethods().iterator();
				while(it_meth_req.hasNext()){
					IMethodBinding inter = it_meth_req.next();
					if (ligne.contains(inter.getName())){
						bw.write("@ProvidedMethod(annotationSrc={\"plug-in ECONET\",\"doComponent\"},componentName{\""+ current.getKey() + "\"})\n");
					}
				}
			}
		}
	}
}
