package econet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;


import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;



/**
 * @author Tima Camara
 * @date 26/03/2009
 *  
 */

public class ASTActionDelegate  {

	
	
	private static ASTActionDelegate aSTActionDelegate  = null;
	
	/**
	 * We cache the parent window object to create the message dialog.
	 */

	
		
	// local java project reference
	private IJavaProject javaProject;
	// project in the workspace
	//private IProject project;
	// project name in the workspace
	private String projectName;
	// types of interest
	private static Vector<IType> typesOfInterest;
	/**
	 *  Table of information.
	 */
	private static TypesTable table;
	
	/**
	 * Table of communications.
	 */
	public static Communications communications;
	
	/**
	 * Data structure for coding the composite structure
	 */
	private static  HashMap<String, String> structure = new HashMap<String, String>();

	//private RuleManager ruleManager;
	
	/**
	 * Default constructor.
	 */
	private ASTActionDelegate() {
		this.projectName = "";
		this.javaProject = null;
		//this.units = new Vector<ICompilationUnit>();
		ASTActionDelegate.setTypesOfInterest(new Vector<IType>());
	}

	
	public synchronized static ASTActionDelegate getInstance() {
		if (aSTActionDelegate == null){
			aSTActionDelegate = new ASTActionDelegate();	
		}
		
		return aSTActionDelegate;		
	}


	/**
	 * Get all the compilation unit corresponding to Java resources in
	 * the current Java project. 
	 * That means classes and interfaces (.java)
	 * @return
	 */
	public Vector<ICompilationUnit> getUnitsOfInterest() {
		IPackageFragmentRoot[] ipfr;
		Vector<ICompilationUnit> icu = new Vector<ICompilationUnit>();
		try {
			// acces the package root for Java resources
			ipfr = javaProject.getAllPackageFragmentRoots();
			for (int i = 0; i < ipfr.length; i++) {
				// select internal resources
				if (!ipfr[i].isExternal()) {
					// get the inner packages
					IJavaElement [] ije =  ipfr[i].getChildren();
					for (int j = 0; j < ije.length; j++) {
						// cast needed here 
						IPackageFragment pf = (IPackageFragment) ije[j];
						// if there are Java resources inside
						if (pf.containsJavaResources()) {
							// search for compilation unit
							ICompilationUnit [] tmp = pf.getCompilationUnits();
							for (int k = 0; k < tmp.length; k++) {
								ICompilationUnit cu = tmp[k];
								icu.add(cu);
							}
						}
					}
				}
			}
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
		return icu;
	}
	
	public List<IType> getComponentsTypes() {
		List<IType> componentsList = new ArrayList<IType>();
		for (IType type : ASTActionDelegate.getTypesOfInterest()) {
			if (ASTActionDelegate.getTable().isComponentType(type.getFullyQualifiedName())) {
				componentsList.add(type);
			}
		}
		return componentsList;
	}



	public void setJavaProject(IJavaProject projectJava) {
		this.javaProject = projectJava;
	
	}
	
	public IJavaProject getJavaProject() {
		return javaProject;
	}


	public static Vector<IType> getTypesOfInterest() {
		return typesOfInterest;
	}


	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}


	public String getProjectName() {
		return projectName;
	}


	public static void setTable(TypesTable table) {
		ASTActionDelegate.table = table;
	}


	public static TypesTable getTable() {
		return table;
	}


	public static void setTypesOfInterest(Vector<IType> typesOfInterest) {
		ASTActionDelegate.typesOfInterest = typesOfInterest;
	}


	public static void setCommunications(Communications communications) {
		ASTActionDelegate.communications = communications;
	}


	public static Communications getCommunications() {
		return communications;
	}


	public static void setStructure(HashMap<String, String> structure) {
		ASTActionDelegate.structure = structure;
	}


	public static HashMap<String, String> getStructure() {
		return structure;
	}


}
