package econet;

import java.util.HashMap;

import org.eclipse.jdt.core.dom.IMethodBinding;

/**
 * Class to store communications.
 * @author jroyer
 *
 */
public class Communications extends HashMap<String, InfoCom> {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Default constructor.
	 */
	public Communications() {
		super();
		//this.table = new HashMap<String, InfoCom>();
	}
	
	/**
	 * Get the communications of an emitter.
	 * @param em
	 * @return
	 */
	public InfoCom getCom(String em) {
		return this.get(em);
	}

	/**
	 * Add in the communications of emitter em the receiver rec
	 * with the message mesg.
	 * @param em
	 * @param rec
	 * @param im
	 */
	public void addCom(String em, String rec, IMethodBinding im) {
		InfoCom com;
		if (this.containsKey(em)) {
			com = this.get(em);
			if (!com.contains(rec, im)) {
				com.addCom(rec, im);
			} 
		} else {
			// em is unknown in the table
			com = new InfoCom();
			com.addCom(rec, im);
		}
		this.put(em, com);
	}
	
	/**
	 * String description.
	 */
	public String toString() {
		String result = "";
		for (String em : this.keySet()) {
			String tmp = " Communications from " + em;
			InfoCom com = this.get(em);
				result += tmp +  com;
		}
		return result;
	}
	

}
