
package econet;

import java.util.Vector;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

/**
 * Dedicated visitor to extract the communications of a type of interest
 * MethodDeclaration
 * MethodInvocation
 */
public class ExtractCommunications extends SimpleVisitor {

	/**
	 *  Current type binding.
	 */
	private ITypeBinding maintype = null;
	
	private String fullname;
	
	/**
	 * Visit ASTNode.
	 * to collect a possible structure.
	 */
	public void preVisit(ASTNode node) {
		// catch the enclosing type
		if (node.getNodeType() == ASTNode.TYPE_DECLARATION) {
			TypeDeclaration main = (TypeDeclaration) node;
			this.maintype = main.resolveBinding();
			this.fullname = maintype.getQualifiedName();
		}
	}

	/**
	 * Visit method call to find messages.
	 */
	public boolean visit(MethodInvocation call) {
		//System.out.print(" visit methode invoc " + call);
		IMethodBinding im = call.resolveMethodBinding();
		Expression exp = call.getExpression();
		// name for the receiver expression
		String recname;
		if (exp != null) {
			ITypeBinding rec = exp.resolveTypeBinding();
			recname = rec.getQualifiedName();
		} else {
			// TODO probleme la sinon ca peut-etre this
			if (call.getName().getFullyQualifiedName().equals("assertTrue")) {
				System.err.println(" call exp null ? fait chier !!!! " + call);	
				recname = "PROBLEM!!!!";
			} else {
				// assume it is this.call
				recname = this.fullname;
			}
		}
		ASTActionDelegate.getInstance();
		ASTActionDelegate.getInstance();
		if (this.fullname != recname 
				&& ASTActionDelegate.getTable().isOfInterest(recname) 
				&& ASTActionDelegate.getTable().isComponentType(recname)) {
			//ASTActionDelegate.communications.
			ASTActionDelegate.communications.addCom(this.fullname, recname, im);
		}
		// needed to parse internal calls
		return true;
		
	}

}