
package econet;


import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;

/**
 * Dedicated visitor to extract the structure of a type of interest.
 */
class ExtractStructure extends SimpleVisitor {

	/**
	 *  Maintype binding.
	 */
	private ITypeBinding maintype = null;
	
	/**
	 * Visit ASTNode.
	 * to collect a possible structure.
	 */
	public void preVisit(ASTNode node) {
		// assume it is the main type but ensured by the caller
		if (node.getNodeType() == ASTNode.TYPE_DECLARATION) {
			TypeDeclaration main = (TypeDeclaration) node;
			maintype = main.resolveBinding();
			String fullname = maintype.getQualifiedName();
			//System.out.println(" Extracting structure for " + fullname);
			if (ASTActionDelegate.getTable().isOfInterest(fullname) 
					&& !ASTActionDelegate.getTable().isResolved(fullname)
					&& this.maintype.isClass()) {
				// set component type indicator
				ASTActionDelegate.getTable().setComponentType(fullname);
				// add the resolved type in the table
				MyIType mit = ASTActionDelegate.getTable().get(fullname).getIbind();
				mit.setIbind(maintype);
				// compute the structure
				mit.storeStructure();
				ASTActionDelegate.getTable().setType(fullname, mit);
				}
		}
	}

}