package econet;
import java.util.Vector;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.dom.IVariableBinding;


/**
 * Class for storing structure with full information.
 * @author jroyer
  */
public class Fields extends Vector<IVariableBinding> {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Test if iv name exists in the fields.
	 * @param iv name
	 * TODO improve 
	 * @return
	 */
	public boolean containsKey(String iv) {
		for (IVariableBinding f : this) {
			if (iv.equals(f.getName())) {
				return true;
			}
		}
		return false;
	}
	
	/**
	 * Merge the fields of the second to the first.
	 * Masking is taken into account
	 * @param other
	 * @return
	 */
	public Fields merge(Fields other) {
		Fields result = new Fields();
		result.addAll(this);
		for (IVariableBinding f : other) {
			String name = f.getName();
			if (!this.containsKey(name)) {
				result.add(f);
			}
		}
		return result;
	}
	
	/**
	 * Filter the default-package fields.
	 * @return
	 */
	public Fields filter() {
		Fields result = new Fields();
		for (IVariableBinding f : this) {
			//f.getModifiers();
			if (f.getModifiers() != Flags.AccDefault) {
				result.add(f);
			}
		}
		return result;
	}
	
	/**
	 * Check if it has a public or default-package field.
	 * @return
	 */
	public boolean hasPublicFields() {
		boolean result = false;
		for (IVariableBinding f : this) {
			int m = f.getModifiers();
			if ((m == Flags.AccDefault) || (m == Flags.AccPublic)) {
				return true;
			}
		}
		return result;
	}
	
	/**
	 * String representation.
	 */
	public String toString() {
		String result = "[";
		for (IVariableBinding ivb : this) {
			result += ivb.getName()  + " : " + ivb.getType().getQualifiedName()+ " ";
		}
		return result + "]";
	}

}
