package econet;

import java.util.Collection;

import org.eclipse.jdt.core.dom.IMethodBinding;

import econet.Decision.Values;

/**
 * Class for information about the types
 * @author jroyer
 *
 */
public class Information {
	
	/**
	 * Decision indicator.
	 */
	private Decision data;
	
	/**
	 * Main point indicator.
	 */
	private boolean root;
	
	/**
	 * Add type resolved.
	 */
	private MyIType ibind;

	/**
	 * Utility flag.
	 */
	private boolean viewed;
	
	/**
	 * Cycle structure indicator.
	 */
	private boolean cycle;
	
	/**
	 * required Interface
	 */
	private Interface requiredinterface;
	
	
	/**
	 * provided interface 
	 */
	private Interface providedInterface;
	
	/**
	 * Default constructor.
	 */
	public Information() {
		this.data = new Decision();
		this.ibind = new MyIType();
		this.root = false;
		this.viewed = false;
		this.cycle = false;
	}
	
	/**
	 * Constructor for root type.
	 * @param r
	 */
	public Information(boolean r) {
		this(); 
		this.root = true;
	}

	/**
	 * String description.
	 */
	public String toString() {
		String result = "";
		if (this.data.isDataType()) {
			result = " Data type ";
		} else if (this.data.isComponentType()) {
			result = " Component type ";
		} else {
			result = " undefined ";
		}
		if (this.root) {
			result += " ROOT ";
		}
		if (this.ibind != null) {
			result += " binding " + this.ibind;
		}
		return result + " VIEWED=" + this.viewed + " CYCLE=" + this.cycle;
	}
	
	/**
	 * Set data type indicator.
	 * @param data
	 */
	public void setDataType(boolean data) {
		if (data) {
			this.data = new Decision(Values.DATA);
		}
	}

	/**
	 * Set component type indicator.
	 * @param data
	 */
	public void setComponentType(boolean data) {
		if (data) {
			this.data = new Decision(Values.COMP);
		} 
	}
	
	/**
	 * Set the resolved type.
	 * @param it
	 */
	public void setType(MyIType it) {
		this.ibind = it;
	}
	
	/**
	 * Set root indicator.
	 */
	public void setRoot() {
		this.root = true;
	}

	/**
	 * Check if type information is resolved.
	 * @return
	 */
	public boolean isResolved() {
		return (this.ibind.isResolved());
	}
	
	/**
	 * test if has fields.
	 * @return
	 */
	public boolean hasFields() {
		return this.ibind.hasFields();
	}
	
	/**
	 * Check if type information is resolved.
	 * @return
	 */
	public boolean isDataType() {
		return this.data.isDataType();
	}
	
	/**
	 * Check if type information is resolved.
	 * @return
	 */
	public boolean isComponentType() {
		return this.data.isComponentType();
	}

	/**
	 * Get ITypeBinding.
	 * @return
	 */
	public MyIType getIbind() {
		return ibind;
	}

	public boolean isViewed() {
		return viewed;
	}

	public void setViewed(boolean viewed) {
		this.viewed = viewed;
	}

	public boolean isCycle() {
		return cycle;
	}

	public void setCycle(boolean cycle) {
		this.cycle = cycle;
	}
	
	
	public Interface getRequiredInterface() throws Exception {
		if (this.data.isComponentType())
			return requiredinterface;
		else throw new Exception("error : Information.getRequiredInterface : " 
				+ this.ibind.getFullName() + " is not a component");
	}

	public void setRequiredInterface(Interface requiredInterface) throws Exception {
		if (this.data.isComponentType())
			this.requiredinterface = requiredInterface;
		else throw new Exception("error : Information.setRequiredInterface : " 
				+ this.ibind.getFullName() + " is not a component");
	}

	public Interface getProvidedInterface() throws Exception {
		if (this.data.isComponentType())
			return providedInterface;
		else throw new Exception("error : Information.getProvidedInterface : " 
				+ this.ibind.getFullName() + " is not a component");
		
	}

	public void setProvidedInterface(Interface providedInterface) throws Exception {
		if (this.data.isComponentType())
			this.providedInterface = providedInterface;
		else throw new Exception("error : Information.setProvidedInterface : " 
				+ this.ibind.getFullName() + " is not a component");
	}
	
	public void addProvidedMethod(IMethodBinding method) throws Exception {
		if (this.data.isComponentType())
			this.providedInterface.addMethod(method);
		else throw new Exception("error : Information.addProvidedMethod : " 
				+ this.ibind.getFullName() + " is not a component");
	}
	
	public void addRequiredMethod(IMethodBinding method) throws Exception {
		if (this.data.isComponentType())
			this.requiredinterface.addMethod(method);
		else throw new Exception("error : Information.addRequiredMethod : " 
				+ this.ibind.getFullName() + " is not a component");
	}
	
	public void addProvidedMethods(Collection<IMethodBinding> methods) throws Exception {
		if (this.data.isComponentType())
			this.providedInterface.addMethods(methods);
		else throw new Exception("error : Information.addProvidedMethod : " 
				+ this.ibind.getFullName() + " is not a component");
	}
	
	public void addRequiredMethods(Collection<IMethodBinding> methods) throws Exception {
		if (this.data.isComponentType())
			this.requiredinterface.addMethods(methods);
		else throw new Exception("error : Information.addRequiredMethod : " 
				+ this.ibind.getFullName() + " is not a component");
	}
	
}
