package econet;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.jdt.core.dom.IMethodBinding;

public class Interface {

	private String fullname = "";
	private Set<IMethodBinding> methodList;

	public Interface() {
		methodList = new HashSet<IMethodBinding>();
	}

	// public ProvidedInterface(Interface interfac) {
	// methodList = new HashSet<IMethod>();
	// }

	public void addMethod(IMethodBinding method) {
		if (!this.CollectionContains(method))
			this.methodList.add(method);
	}

	public void addMethods(Collection<IMethodBinding> methods) {
		for (IMethodBinding method : methods) {
			if (!this.CollectionContains(method))
				this.methodList.add(method);
		}
	}

	public Set<IMethodBinding> getMethods() {
		return this.methodList;
	}

	public String toString() {
		String res = "";
		for (IMethodBinding method : this.methodList)
			res += method.getName() + "\r";
		return res;
	}

	public String getFullname() {
		return fullname;
	}

	public void setFullname(String fullname) {
		this.fullname = fullname;
	}

	public boolean CollectionContains(IMethodBinding im) {
		boolean result = false;
		for (IMethodBinding method : this.methodList) {
			if (im.getName().equals(method.getName())) {
				result = true;
			}
		}

		return result;
	}
}
