package econet;

import java.util.HashMap;
import java.util.Vector;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IMethodBinding;

/**
 * Class to store per type name the set of required services
 * @author jroyer
 *
 */
public class Provided extends HashMap<String, Vector<IMethod>>{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public String toString() {
		String result = "";
		for (String typ : this.keySet()) {
			result += typ + " :::";
			for(IMethod im : this.get(typ)) {
					result += " " + this.computeSignature(im);
			}
			result += "\n";
		}
		return result;
	}
	
	/**
	 * Compute a readable signature without fully qualified names.
	 * @param im
	 * @return
	 */
	public String computeSignature(IMethod im) {
		try {
			String result = Signature.toString(im.getSignature(), im.getElementName(), im.getParameterNames(), true, true);
			return result;
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
		return "";
	}
	
	/**
	 * Check if the req method has a corresponding 
	 * provided method.
	 * TODO
	 * @param req
	 */
	public void exists(String trec, IMethodBinding req) {
		Vector<IMethod> im = this.get(trec);
		for (IMethod m : im) {
			try {
				System.out.println("                 " + Signature.toString(m.getSignature(), m.getElementName(), m.getParameterNames(), true, true));
				System.out.println("         resolue ? " + m.isResolved());
			} catch (JavaModelException e) {
				e.printStackTrace();
			}
		}
	}

}
