
package econet;


import java.io.IOException;

import annotation.AnnotationEconet;

import rules.FindComponentsLinks;
import rules.FindInterfaces;
import rules.FlagEnumerations;
import rules.FlagFromAttributesVisibility;
import rules.FlagFromGettersAndSetters;
import rules.FlagFromJavaInterfaces;
import rules.FlagFromNonComponentAttributes;
import rules.FlagMethodsParametersType;
import rules.FlagStaticMethodsParametersType;
import rules.GetTypesOfInterest;
import rules.Utils;
import wizard.ExtractionProcessWizard;

/**
 * 
 * @author Tima Camara
 * class rule manager, which execute the extraction process
 */

public class RuleManager {
	
	private static RuleManager ruleManager  = null;

	public boolean defaultProcess ;
	
	private Utils util; 
	
	public String[] listNameOfRuleProcess;
	
	private GetTypesOfInterest getTypesOfInterest = new GetTypesOfInterest(ASTActionDelegate.getInstance());
	
	private static FlagFromJavaInterfaces flagFromJavaInterfaces = new FlagFromJavaInterfaces(ASTActionDelegate.getInstance());
	
	private FlagEnumerations flagEnum = new FlagEnumerations(ASTActionDelegate.getInstance());
	private static FlagFromAttributesVisibility flagAttrvisib = new FlagFromAttributesVisibility(ASTActionDelegate.getInstance());
	private static FlagFromGettersAndSetters flagGetset = new FlagFromGettersAndSetters(ASTActionDelegate.getInstance());
	
	private static FlagFromNonComponentAttributes flagNocomp = new FlagFromNonComponentAttributes(ASTActionDelegate.getInstance());
	private static FlagMethodsParametersType flagMeth = new FlagMethodsParametersType(ASTActionDelegate.getInstance());
	private static FlagStaticMethodsParametersType flagStatic = new FlagStaticMethodsParametersType(ASTActionDelegate.getInstance());	
	
	
	
	private static FindComponentsLinks findComponentsLinks = new FindComponentsLinks(ASTActionDelegate.getInstance());
	private static FindInterfaces findInterfaces = new FindInterfaces(ASTActionDelegate.getInstance());

	private RuleManager(){}	
		
	public synchronized static RuleManager getInstance() {
		if (ruleManager == null){
			ruleManager = new RuleManager();
			ruleManager.defaultProcess = true;
				try {
					ruleManager.util =  new Utils();
				} catch (IOException e) {
					e.printStackTrace();
				}
		
		}
		
		return ruleManager;		
	}
	
	@SuppressWarnings("static-access")
	public void execute() throws Exception {
		
		getTypesOfInterest.run();
		ASTActionDelegate.getInstance();
		ASTActionDelegate.setTable(new TypesTable(ASTActionDelegate.getInstance().getTypesOfInterest()));

		flagFromJavaInterfaces.run();
		ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 20);
		
		System.out.println("\nconstruct table");
		util.write();
		
		if (this.defaultProcess){
		
			flagEnum.run();
			util.write();
			System.out.println("\n"+flagEnum);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

			flagAttrvisib.run();
			util.write();
			System.out.println("\n"+flagAttrvisib);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

			
			flagGetset.run();
			util.write();
			System.out.println("\n"+flagGetset);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

							
			flagNocomp.run();
			util.write();
			System.out.println("\n"+flagNocomp);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

			flagMeth.run();
			util.write();
			System.out.println("\n"+flagMeth);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

			flagStatic.run();	
			util.write();
			System.out.println("\n"+flagStatic);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

			findComponentsLinks.run();
			util.write();
			System.out.println("\n"+findComponentsLinks);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

			findInterfaces.run();
			//util.write();
			System.out.println("\n"+findInterfaces);
			ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + 10);

			
				
		}
		else{
			int n = 100 / listNameOfRuleProcess.length;
			
			for(int j=0;j<listNameOfRuleProcess.length;j++){ 
				System.out.println(listNameOfRuleProcess[j]);
				if( listNameOfRuleProcess[j].equals(findInterfaces.getName()) )
					findInterfaces.run();
				
				else if ( listNameOfRuleProcess[j].equals(findComponentsLinks.getName()) )
					findComponentsLinks.run();
				
					else if ( listNameOfRuleProcess[j].equals(flagStatic.getName()) )
						flagStatic.run();
				
						else if ( listNameOfRuleProcess[j].equals(flagMeth.getName()) )
							flagMeth.run();
						
							else if ( listNameOfRuleProcess[j].equals(flagNocomp.getName()) )
								flagNocomp.run();
				
								else if ( listNameOfRuleProcess[j].equals(flagGetset.getName()) )
									flagGetset.run();
								
									else if ( listNameOfRuleProcess[j].equals(flagAttrvisib.getName()) )
										flagAttrvisib.run();
				
											else if ( listNameOfRuleProcess[j].equals(flagEnum.getName()) )
												flagEnum.run();
				ExtractionProcessWizard.bar.setSelection(ExtractionProcessWizard.bar.getSelection() + n);
				util.write();
			}
			
		}
		new AnnotationEconet(ASTActionDelegate.getInstance());
		
		// methode to annote the java project
	}

}
