package rules;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;



import econet.ASTActionDelegate;
import econet.Communications;
import econet.GenericASTParser;
import econet.ExtractCommunications;


public class FindComponentsLinks extends SimpleRule {
	
	private final String name = "FindComponentsLinks";

	public FindComponentsLinks(ASTActionDelegate astAD) {
		super(astAD);
	}

	@Override
	public void run() {
		ASTActionDelegate.communications = new Communications();
		System.out.println("FindComponentsLinks.run : nb component = " + this.getComponentList().size());
		for (IType component : this.astActionDelegate.getComponentsTypes()) {
			FindComponentLinks(component);
		}

	}
	
	private void FindComponentLinks(IType component) {
		//TODO verifier si c'est un composite
		if ( false) { 
			// pour chaque composant du composite
			//for (ComponantType subComp : comp.listComponents() {
			//	findCommunication(subComp);
			//}
		}
		else {
			findComponentLinksfinal(component);
		}
	}

	
	private void findComponentLinksfinal(IType component) {
		GenericASTParser ast = new GenericASTParser(new ExtractCommunications());
		ICompilationUnit ic = component.getCompilationUnit();
		CompilationUnit cu = ast.parse(ic);
		ast.run(cu);
	}

	public String getName() {
		return name;
	}
	
	private List<IType> getComponentList() {
		List<IType> componentList = new ArrayList<IType>();
		ASTActionDelegate.getInstance();
		System.out.println("getComponentList : nb type = " + ASTActionDelegate.getTypesOfInterest().size());
		ASTActionDelegate.getInstance();
		for(IType i : ASTActionDelegate.getTypesOfInterest()) {
			String fn = i.getFullyQualifiedName();
			ASTActionDelegate.getInstance();
			if(ASTActionDelegate.getTable().isComponentType(fn)) {
				System.out.println("component found : name = " + fn);
				componentList.add(i);
			}
            
		}
		return componentList;
	}

}
