package rules;

import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jface.operation.ModalContext;

import econet.ASTActionDelegate;

public class FindInterfaces extends SimpleRule {

	private final String  name = "FindInterfaces";
	
	public FindInterfaces(ASTActionDelegate astActionDelegate) {
		super(astActionDelegate);
	}

	@Override
	public void run() throws Exception {
		System.out.println("nb communications : " + ASTActionDelegate.communications.size());
		for (String component : ASTActionDelegate.communications.keySet()) {
			this.setDefaulInterfacetname(component);
			for (String componentCalled : ASTActionDelegate.communications.get(component).keySet()) {
				Set<IMethodBinding> methods = ASTActionDelegate.communications.get(component).get(componentCalled);
				System.out.println("component = " +  component);
				System.out.println("componentCalled = " +  componentCalled);
				ASTActionDelegate.getInstance().getTable().addProvidedMethods(componentCalled, methods);
				ASTActionDelegate.getInstance().getTable().addRequiredMethods(component, methods);
			}
			
			System.out.println("\n new component");
		}

	}

	public String getName() {
		return name;
	}
	
	private void setDefaulInterfacetname(String fullnameComponent) throws Exception {
		String providedName = fullnameComponent + "DefaultProvidedInterface";
		String requiredName = fullnameComponent + "DefaultRequiredInterface";
		
		ASTActionDelegate.getInstance().getTable().getProvidedInterface(fullnameComponent).setFullname(providedName);
		ASTActionDelegate.getInstance().getTable().getRequiredInterface(fullnameComponent).setFullname(requiredName);
	}


}
