package rules;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

import econet.ASTActionDelegate;

public class FlagEnumerations extends SimpleRule {

	private final String name = "FlagEnumerations";
	
	public FlagEnumerations(ASTActionDelegate astAD) {
		
		super(astAD);
		
	}

	public String getName() {
		return name;
	}
	
	@Override
	public void run() {
		try {
			for (IType it : ASTActionDelegate.getTypesOfInterest()) {
				if (it.isInterface() | it.isEnum()) {
					ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
				}
			}
		}
		catch (JavaModelException e) {
			e.printStackTrace();
		}
	}

}
