package rules;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

import econet.ASTActionDelegate;

public class FlagFromAttributesVisibility extends SimpleRule {

	private final String name = "FlagFromAttributesVisibility";
	
	private double threshold = 0.7;
	
	public FlagFromAttributesVisibility(ASTActionDelegate astAD) {
		
		super(astAD);
		
	}

	public String getName() {
		return name;
	}
	
	@Override
	public void run() {
		try {
			ASTActionDelegate.getInstance();
			for (IType it : ASTActionDelegate.getTypesOfInterest()) {
				if (!it.isInterface()) {
					int nbFields = it.getFields().length;
					if (nbFields != 0) {
						int nbPublicFields = getPublicFieldsNumber(it);
						if (nbPublicFields / nbFields >= this.threshold) {
							ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
						}
					}
				}
			}
		}
		catch (JavaModelException e) {
			e.printStackTrace();
		}

	}
	
	private int getPublicFieldsNumber(IType it) {
		int nbPublicFields = 0;
		try {
			for (IField ifield : it.getFields()) {
				int fieldFlags = ifield.getFlags();
				if (Flags.isPublic(fieldFlags)) {
					nbPublicFields++;
				}
			}
		}
		catch (JavaModelException e) {
				e.printStackTrace();
		}
		return nbPublicFields;
	}

}
