package rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

import econet.ASTActionDelegate;

public class FlagFromGettersAndSetters extends SimpleRule {
	
	private final String name = "FlagFromGettersAndSetters";
	
	private double threshold = 0.7;
	
	public FlagFromGettersAndSetters(ASTActionDelegate astAD) {
		
		super(astAD);
		
	}

	public String getName() {
		return name;
	}

	@Override
	public void run() {
		// TODO Auto-generated method stub
		for (IType it : ASTActionDelegate.getTypesOfInterest()) {
			try {
				if (!it.isInterface()) {
					int nbFields = it.getFields().length;
					if (nbFields != 0) {
						List<String> methodsName = getGettersAndSettersName(it);
						List<String> fieldsName = getFieldsName(it);
						HashMap<String, Boolean> hasGetterOrSetter = new HashMap<String, Boolean>();
						for (String fieldName : fieldsName) {
							hasGetterOrSetter.put(fieldName, false);
							for (String methodName : methodsName) {
								if (methodName.endsWith(fieldName) | methodName.endsWith("All" + fieldName)) {
									hasGetterOrSetter.put(fieldName, true);
								}
							}
						}
						int nbFieldsWithGetterOrSetter = 0;
						for (String fieldName : fieldsName) {
							Boolean fieldNameKey = hasGetterOrSetter.get(fieldName);
							if (fieldNameKey == true) {
								nbFieldsWithGetterOrSetter++;
							}
						}
						if (nbFieldsWithGetterOrSetter / nbFields >= this.threshold) {
							ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
						}
					}
				}
			}
			catch (JavaModelException e) {
				e.printStackTrace();
			}
		}
		
	}
	
	public List<String> getGettersAndSettersName(IType it) throws JavaModelException {
		List<String> gettersAndSetters = new ArrayList<String>();
		for (IMethod im : it.getMethods()) {
			String imName = im.getElementName();
			if (imName.startsWith("get") | imName.startsWith("set")) {
				gettersAndSetters.add(imName);
			}
		}
		return gettersAndSetters;
	}
	
	public List<String> getFieldsName(IType it) throws JavaModelException {
		List<String> fieldsName = new ArrayList<String>();
		for (IField field : it.getFields()) {
			String fieldName = field.getElementName();
			fieldsName.add(fieldName.substring(0, 1).toUpperCase().concat(fieldName.substring(1, fieldName.length())));
		}
		return fieldsName;
	}

}
