package rules;

import java.util.Vector;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

import econet.ASTActionDelegate;

public class FlagFromJavaInterfaces extends SimpleRule {
	
	private final String name = "FlagFromJavaInterfaces";
	
	public FlagFromJavaInterfaces(ASTActionDelegate astActionDelegate) {
		super(astActionDelegate);
	}

	@Override
	public void run() {
		ASTActionDelegate.getInstance();
		Vector<IType> iTypes = ASTActionDelegate.getTypesOfInterest();
		String[] interfaces = null;		
		
		for (IType it : iTypes) {
			try {
				interfaces = it.getSuperInterfaceNames();
				for (String i : interfaces) {
					ASTActionDelegate.getInstance();
					for (IType itAux : ASTActionDelegate.getTypesOfInterest()) {
						if (i.equals(itAux.getElementName())) {
							ASTActionDelegate.getInstance();
							if (ASTActionDelegate.getTable().isOfInterest(itAux.getFullyQualifiedName())) {
								ASTActionDelegate.getInstance();
								ASTActionDelegate.getTable().setComponentType(it.getFullyQualifiedName());
							}
						}
					}
					
				}
			} catch (JavaModelException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
			
	}

	public String getName() {
		return name;
	}

}