package rules;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

import econet.ASTActionDelegate;

public class FlagFromNonComponentAttributes extends SimpleRule {

	private final String name = "FlagFromNonComponentAttributes";
	
	public FlagFromNonComponentAttributes(ASTActionDelegate astAD) {
		
		super(astAD);
		
	}

	public String getName() {
		return name;
	}

	@Override
	public void run() {
		// TODO Auto-generated method stub
		try {
			for (IType it : ASTActionDelegate.getTypesOfInterest()) {
				if (!it.isInterface()) {
					boolean isDataType = true;
					if (it.getFields().length != 0) {
						for (IField field : it.getFields()) {
							for (IType itAux : ASTActionDelegate.getTypesOfInterest()) {
								if (Signature.toString(field.getTypeSignature()).equals(itAux.getElementName())) {
									if (ASTActionDelegate.getTable().isOfInterest(itAux.getFullyQualifiedName())) {
										if (ASTActionDelegate.getTable().isComponentType(itAux.getFullyQualifiedName())) {
											isDataType = false;
										}
									}
								}
							}
						}
						if (isDataType) {
							ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
						}
					}
				}
			}
		}
		catch (JavaModelException e) {
			e.printStackTrace();
		}
	}

}
