package rules;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

import econet.ASTActionDelegate;

// flag the type of the parameters of non constructors and non static methods
public class FlagMethodsParametersType extends SimpleRule {

	private final String name = "FlagMethodsParametersType";
	
	public FlagMethodsParametersType(ASTActionDelegate astAD) {
		
		super(astAD);
		
	}

	public String getName() {
		return name;
	}

	@Override
	public void run() {
		// TODO Auto-generated method stub
		for (IType it : ASTActionDelegate.getTypesOfInterest()) {
			try {
				IMethod[] ims = it.getMethods();
				for (IMethod im : ims) {
					flagMethodParametersType(this.astActionDelegate, im);
				}
			}
			catch (JavaModelException e) {
				e.printStackTrace();
			}
		}

	}
	
	private void flagMethodParametersType(ASTActionDelegate astAD, IMethod im) {
		
		try {
			if (!(im.isConstructor() | Flags.isStatic(im.getFlags()))) {
				for (IType it : ASTActionDelegate.getTypesOfInterest()) {
					if (Signature.toString(im.getReturnType()).equals(it.getElementName()) & !it.isInterface()) {
						ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
					}
				}
				String[] imParametersTypes = im.getParameterTypes();
				for (String parameterType : imParametersTypes) {
					for (IType it : ASTActionDelegate.getTypesOfInterest()) {
						if (Signature.toString(parameterType).equals(it.getElementName()) & !it.isInterface()) {
							ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
						}
					}
				}
			}
		}
		catch (JavaModelException e) {
			e.printStackTrace();
		}
		
	}

}
