package rules;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

import econet.ASTActionDelegate;

public class FlagStaticMethodsParametersType extends SimpleRule {
	
	private final String name = "FlagStaticMethodsParametersType";
	
	public FlagStaticMethodsParametersType(ASTActionDelegate astActionDelegate) {
		
		super(astActionDelegate);
		
	}

	public String getName() {
		return name;
	}

	@Override
	public void run() {
		for (IType it : ASTActionDelegate.getTypesOfInterest()) {
			try {
				IMethod[] ims = it.getMethods();
				for (IMethod im : ims) {
					flagMethodStaticParametersType(this.astActionDelegate, im);
				}
			}
			catch (JavaModelException e) {
				e.printStackTrace();
			}
		}

	}
	
	private void flagMethodStaticParametersType(ASTActionDelegate astAD, IMethod im) {
		
		try {
			if (Flags.isStatic(im.getFlags())) {
				for (IType it : ASTActionDelegate.getTypesOfInterest()) {
					if (Signature.toString(im.getReturnType()).equals(it.getElementName()) & !it.isInterface()) {
						ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
					}
				}
				String[] imParametersTypes = im.getParameterTypes();
				for (String parameterType : imParametersTypes) {
					for (IType it : ASTActionDelegate.getTypesOfInterest()) {
						if (Signature.toString(parameterType).equals(it.getElementName()) & !it.isInterface()) {
							ASTActionDelegate.getTable().setDataType(it.getFullyQualifiedName());
						}
					}
				}
			}
		}
		catch (JavaModelException e) {
			e.printStackTrace();
		}
		
	}

}
