package rules;

import java.util.Vector;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

import econet.ASTActionDelegate;

public class GetTypesOfInterest extends SimpleRule {

	public GetTypesOfInterest(ASTActionDelegate astActionDelegate) {
		super(astActionDelegate);
	}

	@Override
	public void run() {
		Vector<IType> iTypes = new Vector<IType>();
		Vector<ICompilationUnit> compilUnits = this.getUnitsOfInterest();

		for(ICompilationUnit u : compilUnits) {
			
			try {
				IType [] alls = u.getTypes();
				IType iType = alls[0];
				if (iType.isClass() || iType.isInterface()) iTypes.add(iType);
			} catch (JavaModelException e1) {
				System.err.println(e1); 
				e1.printStackTrace();
			}
			
		}
		
		ASTActionDelegate.setTypesOfInterest(iTypes);

	}
	
	private Vector<ICompilationUnit> getUnitsOfInterest() {
		/*IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
		IProject project = workspaceRoot.getProject(this.astActionDelegate.getProjectName());
		IJavaProject javaProject = JavaCore.create(project);
		*/
		
		IJavaProject javaProject = ASTActionDelegate.getInstance().getJavaProject();
		Vector<ICompilationUnit> res = new Vector<ICompilationUnit>();
		IPackageFragmentRoot[] root;
				
		try {
			root = javaProject.getAllPackageFragmentRoots();
			for (IPackageFragmentRoot ipfr : root) {
				if (!ipfr.isExternal()) {
					IJavaElement [] javaElements =  ipfr.getChildren();
					for (IJavaElement e : javaElements) {
						IPackageFragment packageFragment = (IPackageFragment)e;
						if (packageFragment.containsJavaResources()) {
							ICompilationUnit [] compilationUnits = packageFragment.getCompilationUnits();
							for (ICompilationUnit c : compilationUnits) {
								res.add(c);
							}
						}
					}
				}
			}
		} catch (JavaModelException e) {
			System.err.println(e);
			e.printStackTrace();
		}
		
		return res;
	}

}
