package rules;

import java.util.ArrayList;
import java.util.List;

import econet.ASTActionDelegate;

public abstract class GroupOfRules extends Rule {
	
	public List<Rule> defaultRules;
	
	public List<Rule> executedRules;
	
	public GroupOfRules(ASTActionDelegate astActionDelegate) {
		
		super(astActionDelegate);
		this.defaultRules = new ArrayList<Rule>();
		this.executedRules = new ArrayList<Rule>();
		
	}
	
	public void run() throws Exception {
		
		for (Rule rule : this.executedRules) {
			rule.run();
		}
		
	}

}
