package rules;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IType;

import econet.ASTActionDelegate;


public class Utils {
	
	private final String path = ResourcesPlugin.getWorkspace().getRoot().getLocation()+"_Econet.log";
	
	private FileWriter f;
	private PrintWriter writer;
	
	public Utils() throws IOException{

		f =  new FileWriter(path);		
		System.out.println(f);
		writer = new PrintWriter( f);
			
	}
	
	public void write() throws IOException {
		
		ASTActionDelegate.getInstance();
		writer.println("\n\n\n ASTActionDelegate CONTENT :" + ASTActionDelegate.getTable().toString());
		
		
		
		Vector<IType> iTypes = ASTActionDelegate.getTypesOfInterest();
		writer.write("nb itypes : " + iTypes.size());


		for(IType i : iTypes) {
			String fn = i.getFullyQualifiedName();
	
			if(ASTActionDelegate.getTable().isComponentType(fn)) {
                writer.write("\n\nComponent found : " + fn + '\n');
            }
			if (ASTActionDelegate.getTable().isDataType(fn)) {
	               writer.write("\n\nDatatype found : " + fn);
			}
			if (ASTActionDelegate.getCommunications() != null) {
				writer.write("\n\ncommunications found :");
				writer.write(ASTActionDelegate.getCommunications().toString());
			}
	
			
		}

	}
	
}