package wizard;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

/**
 * 
 * @author Tima Camara
 *
 */
public class DualDisplay extends Composite {
	
	private Composite my_parent;
	private WizardPage my_wizardPage;
	private static final String addLabel="Add >>";
	private static final String removeLabel="<< Remove";
	private static final String my_rules = "Available Rules";
	private static final String my_order = "Execution Order";
	private Label ruleLabel,orderLabel,buttonLabel;
	private String[] rules;
	private List ruleList;
	static List orderedList;
	private Button addButton,removeButton;
	
	public DualDisplay(WizardPage my_wizardPage,Composite my_parent){
		super(my_parent,SWT.CENTER);
		this.my_wizardPage=my_wizardPage;
		this.setMy_parent(my_parent);
		initialize();
		this.setVisible(false);

	}
	
	public void initialize(){
		 
		// Definit le layout du composite 
		
		GridLayout gridLayout = new GridLayout();
	    gridLayout.numColumns = 7;
	    
	    this.setLayout(gridLayout);
		
	    Composite composite = new Composite(this, SWT.NONE);
	    GridData data = new GridData(GridData.FILL_BOTH);
	    data.horizontalSpan = 2;
	    composite.setLayoutData(data);
	    gridLayout = new GridLayout();
	    gridLayout.numColumns = 1;
	    composite.setLayout(gridLayout);
	    
	    data = new GridData(GridData.FILL);
	    ruleLabel= new Label(composite,SWT.NONE);
	    ruleLabel.setText(my_rules);
	    ruleLabel.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
	    ruleLabel.setLayoutData(data);
	    
	    data = new GridData();
	    data.verticalAlignment = GridData.FILL;
	    String rules[]={"FlagEnumerations",
	    				"FlagFromAttributesVisibility",
	    				"FlagFromGettersAndSetters",
	    				"FlagFromNoComponentAttributes",
	    				"FlagMethodsParametersType",
	    				"FlagStaticMethodsParametersType",
	    				"FindComponentsLinks",
	    				"FindInterfaces"};
		ruleList = new List(composite,SWT.MULTI);
		
		//Pour se rassurer que le rectangle sera assez grand pour montrer toute la liste
		int listHeight = ruleList.getItemHeight() * 10;
		Rectangle trim = ruleList.computeTrim(0, 0, 0, listHeight);
		data.heightHint = trim.height;
		ruleList.setItems(rules);
		ruleList.setLayoutData(data);
		setColor(composite);
		
		// layout buttons
		
		composite = new Composite(this, SWT.NONE);
	    data = new GridData(GridData.FILL_BOTH);
	    data.horizontalSpan = 3;
	    composite.setLayoutData(data);
	    gridLayout = new GridLayout();
	    gridLayout.numColumns = 1;
	    composite.setLayout(gridLayout);

	    data = new GridData(GridData.FILL);
	    buttonLabel= new Label(composite,SWT.NONE);
	    buttonLabel.setText("");
	    buttonLabel.setLayoutData(data);
	    
	   
	    data = new GridData(GridData.FILL);
	    addButton=new Button(composite, SWT.PUSH);
		addButton.setText(addLabel);
		addButton.setLayoutData(data);
		
	    data = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
	    removeButton=new Button(composite, SWT.PUSH);;
		removeButton.setText(removeLabel);
	    removeButton.setLayoutData(data);
	    setColor(composite);
	    // Layout of the orderedlist
	    
	    composite = new Composite(this, SWT.NONE);
	    data = new GridData(GridData.FILL_BOTH);
	    data.horizontalSpan = 2;
	    composite.setLayoutData(data);
	    gridLayout = new GridLayout();
	    gridLayout.numColumns = 1;
	    composite.setLayout(gridLayout);
	    
	    data = new GridData(GridData.FILL);
	    orderLabel= new Label(composite,SWT.NONE);
	    orderLabel.setText(my_order);
	    orderLabel.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
	    orderLabel.setLayoutData(data);
	    
	    data = new GridData();
	    data.verticalAlignment = GridData.FILL;
		orderedList=new List(composite,SWT.MULTI);
		data.heightHint = trim.height;
		data.widthHint=(int)(trim.height*1.7);
	    orderedList.setLayoutData(data);
	    
	    setColor(composite);

	    setColor(this);
	    
	    
	    addListeners();
		
	}
	
	// Change la couleur de l arriere plan
	public void setColor(Composite my_composite){
		my_composite.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
	}
	
public void addListeners(){
		
		/*Ajoute l'item selectionn a la liste des regles et le retire des regles disponibles
		 * 
		 */

			addButton.addSelectionListener(new SelectionAdapter() {
			
				public void widgetSelected(SelectionEvent e) {
			      Object[] selected = ruleList.getSelection();
			      int size=selected.length;
			      
			      for(int i=0; i < size; i++){
			    	  String item= (String) selected[i];
			    	  orderedList.add(item);
			    	  ruleList.remove(item);
			      }
			      updateButtons();

				}
			});
			/*Retire l'item selectionn de la liste des regles et l'ajoute aux regles disponibles
			 * 
			 */

			
			removeButton.addSelectionListener(new SelectionAdapter() {
				
				public void widgetSelected(SelectionEvent e) {
					Object[] selected = orderedList.getSelection();
				     int size=selected.length;
				      
				      for(int i=0; i < size; i++){
				    	  String item= (String) selected[i];
				    	  ruleList.add(item);
				    	  orderedList.remove(item);
				      }
					updateButtons();
					}
				
			});
			
	}
	public void updateButtons(){
		my_wizardPage.getWizard().getContainer().updateButtons();
	}
	// 
	public void update(Boolean displayed){
		setVisible(displayed);
	}
	// Methode utiliser pour obtenir les regles appliqus dans l'ordre
	public static String[] getList(){
		return orderedList.getItems();
	}

	public void setMy_parent(Composite my_parent) {
		this.my_parent = my_parent;
	}

	public Composite getMy_parent() {
		return my_parent;
	}

	public void setRules(String[] rules) {
		this.rules = rules;
	}

	public String[] getRules() {
		return rules;
	}
}

