package wizard;



import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;



/**
 * @author Tima Camara
 * @date 26/03/2009
 * Econet Wizard Class 
 */

public class EconetWizard extends Wizard implements INewWizard
{
    public static String WINDOW_TITLE = "SecurityWizard_Title";
    
    protected LoadWizard loadPage;
    
    protected RuleWizard rulePage;
    
    protected ExtractionProcessWizard extractionProcessPage;
    
	// workbench selection when the wizard was started
	protected IStructuredSelection selection;
	
	// the workbench instance
	protected IWorkbench workbench;

	/**
	 * Constructor for EconetWizard.
	 */

	public EconetWizard() {
		super();
	}
	
	public void addPages()
	{
		loadPage = new LoadWizard(workbench, selection);
		addPage(loadPage);
		rulePage = new RuleWizard();
		addPage(rulePage);
		extractionProcessPage = new ExtractionProcessWizard();
		addPage(extractionProcessPage);
		
	}
	
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		this.selection = selection;

	}

	/*
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#canFinish()
	 * Le wizard doit seulement offrir la possibilit
	 * de presser Finish dans la derniere page

	 */

    public boolean canFinish(){
    	boolean isFinished=false;
        
        if(this.getContainer().getCurrentPage()!=extractionProcessPage)
        	isFinished=false;
        else if (this.getContainer().getCurrentPage()==extractionProcessPage){
        	if(extractionProcessPage.isFinished()==false) isFinished=false;
        	if (extractionProcessPage.isFinished()==true) isFinished=true;
        }
        return isFinished;
    }
    /* 
	   * @see org.eclipse.jface.wizard.IWizard#performFinish()
	   * Cette methode definie l'action effectue lorsque 
	   * le button Finish est appuy
	   */
    public boolean performFinish() {
		dispose();
		return true;
    }
    /* 
	   * @see org.eclipse.jface.wizard.IWizard#performCancel()
	   * Cette action definie l'action effectue lorsque 
	   * le button Cancel est appuy
	   */
	 public boolean performCancel() {
		    boolean ans = MessageDialog.openConfirm(getShell(), "Confirmation", "Are you sure to cancel the task?");
		    if(ans)
		      return true;
		    else
		      return false;
		  }  



}
