package wizard;



import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

import econet.RuleManager;




/**
 * @author Tima Camara
 * @date 26/03/2009
 * Wizard Class to execute process
 */

public class ExtractionProcessWizard extends WizardPage implements Listener{
	

	public static ProgressBar bar;

	Text containerText;
	Button beginProcess;
	String selectedDir;
	
	Label label,processLabel;
	
	boolean completed=false;

	
	public ExtractionProcessWizard() {
		super("Extraction Process Page");
		setTitle("Extraction process of  Java Project");
		setDescription("Please wait...");
		
	}

	
	public void createControl(Composite parent) {
		
		final Composite container = new Composite(parent, SWT.NULL);
		GridLayout gl = new GridLayout();
		gl.numColumns = 1;
		container.setLayout(gl);
	
		
		
		beginProcess = new Button(container, SWT.NONE);

		beginProcess.setText("Begin process");
		
		beginProcess.addListener(SWT.Selection, new Listener() { 
			public void handleEvent(Event event) {
			    try {
			     RuleManager.getInstance().execute();
			     completed=true;
			     getWizard().canFinish();
			     getWizard().getContainer().updateButtons();

			    } catch (Exception e) {
			     e.printStackTrace();
			    }
			   }
		});
			
		final Composite barContainer = new Composite(container, SWT.NONE);
		barContainer.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		barContainer.setLayout(new GridLayout(2, false));
		

		Label l = new Label(barContainer, SWT.NONE);
		l.setText("Processing Data");

		/*
		 * Creating the progress bar
		 * 
		 */
		
		 bar = new ProgressBar(barContainer,SWT.SMOOTH);
		 bar.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		 bar.setBounds(100, 10, 200, 20);
		 bar.setMaximum(100);
			
		 processLabel = new Label(barContainer, SWT.NONE);
	     processLabel.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, false, false));
	     processLabel.setVisible(false);
		
		setControl(container);		
		
	}


	public void handleEvent(Event event) {
		getWizard().getContainer().updateButtons();
	}
	// Cette methode permet de verifier si le button next doit etre actif 
	public boolean canFlipToNextPage(){
			return false;
		
	}
		
	public boolean isFinished(){
		return completed;
	}


}
