package wizard;

import java.io.File;


import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

import org.eclipse.ui.IWorkbench;

import econet.ASTActionDelegate;



/**
 * @author Tima Camara
 * @date 26/03/2009
 * Class to load project java
 * representing the first page of the wizard
 */


public class LoadWizard extends WizardPage implements Listener{

	
	IWorkbench workbench;
	IStructuredSelection selection;
	
	Button projectButton;
	

	IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
	IPath location = root.getLocation();
	String fileFilterPath =  location.toString();
	
	IProject project;
	
	IJavaProject javaProject;

	Text containerText;
	Button buttonSelectDir;
	String selectedDir;
	Boolean nextPage=false;
	
	
	Label label;
	
	public LoadWizard(IWorkbench workbench, IStructuredSelection selection) {
		super("Page1");
		setTitle("Your Project");
		setDescription("Select a Java project in workspace");
		this.workbench = workbench;
		this.selection = selection;
		// Par precaution tous les buttons sont desactivs au depart hormis le Cancel
		//setPageComplete(false);
		
	}

	
	public void createControl(Composite parent) {
		
       		final Composite container = new Composite(parent, SWT.NULL);
        		
        		GridLayout gl = new GridLayout();
        		int ncol = 4;
        		gl.numColumns = ncol;
        		container.setLayout(gl);

                label = new Label(container, SWT.NULL);
        		label.setText("Project:");		
        		containerText = new Text(container, SWT.BORDER | SWT.SINGLE);
        		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
        		containerText.setLayoutData(gd);
        		
        		buttonSelectDir = new Button(container, SWT.PUSH);
        		buttonSelectDir.setText("Browse...");
        		buttonSelectDir.addListener(SWT.Selection, new Listener() { 
        			public void handleEvent(Event event) {
        				DirectoryDialog directoryDialog = new DirectoryDialog(container.getShell());        				
        		        directoryDialog.setFilterPath(fileFilterPath);
        		        directoryDialog.setMessage("Please select a directory and click OK");        		        
        		        String dir = directoryDialog.open();
        		        if(dir != null) {
        		        	containerText.setText(getFileName(dir));
        		        	selectedDir = dir;
        		        	availableProject();
        		        }
        		      }

					public void availableProject() {
						project = root.getProject(containerText.getText());
				        javaProject = JavaCore.create(project);
				        
				        if (javaProject != null){
				        	ASTActionDelegate.getInstance().setJavaProject(javaProject);
				        	ASTActionDelegate.getInstance().setProjectName(containerText.getText());
				        	
				        	//Le boutton next est activ seulement si le projet est valide
				        	nextPage=true;
				    		getWizard().getContainer().updateButtons();

				    						        	
				        }
				        else {
				        	System.out.println("not projet java"); 		
							MessageDialog.openError(getShell(), "No project", containerText.getText());
				        }
						
					}
        		    });

        		setControl(container);		
		
	}
	

	// Cette methode permet de verifier si le button next doit etre actif 
	public boolean canFlipToNextPage(){
		if( nextPage==true)return true;
		else 
			return false;
		
	}
	// Cette methode permet de verifier si le button finish doit etre actif
	// Impossible de finir le wizard a ce niveau
	public boolean canFinish(){
		return false;
	}

	
	public void handleEvent(Event event) {
		getWizard().getContainer().updateButtons();
	}

	public IWizardPage getNextPage(){   
		RuleWizard page = null;
		page = ((EconetWizard)getWizard()).rulePage;
		return page;
	}

	public static String getFileName(String path){
		String fileName = null;
		String separator = File.separator;
		int pos = path.lastIndexOf(separator);
		int pos2 = path.lastIndexOf(".");
		if(pos2>-1)
		fileName =path.substring(pos+1, pos2);
		else
		fileName =path.substring(pos+1);
		return fileName;
	}
	
}
