package wizard;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import econet.RuleManager;

import wizard.DualDisplay;

/**
 * @author Tima Camara
 * @date 26/03/2009
 * Class wizard page that displays the choice 
 * of rules of extraction process 
 */

public class RuleWizard extends WizardPage implements Listener {
	
	Boolean nextPage=false;
	DualDisplay my_dualDisplay;
	Button choix1,choix2;
	Boolean isSelected=true;

	protected RuleWizard() {
		super("Choice Rule Wizard");
		setTitle("Rules ");
		setDescription("Select rules to be applied during extraction process");

	}

	
	public void createControl(Composite parent) {		
		final Composite container = new Composite(parent, SWT.NONE);

		GridLayout gl = new GridLayout();
		int ncol = 2;
		gl.numColumns = ncol;
		container.setLayout(gl);
		
			
		Button choix1 = new Button (container, SWT.RADIO);
		choix1.setText ("Extraction process default");
		choix1.setEnabled(true);
		choix1.setSelection(true);
		choix1.addSelectionListener(new SelectionAdapter() {
		      public void widgetSelected(SelectionEvent e) {
		    	isSelected=true;
		 		getWizard().getContainer().updateButtons();
		        my_dualDisplay.update(false);
		        RuleManager.getInstance().defaultProcess = true;

		        }
		      });
			
		Label label = new Label(container, SWT.NULL);
		label.setText("");	
	
		Button choix2 = new Button (container, SWT.RADIO);
		choix2.setText ("Rules Selection");
		choix2.addSelectionListener(new SelectionAdapter() {
		      public void widgetSelected(SelectionEvent e) {
			    	isSelected=false;
			 		getWizard().getContainer().updateButtons();
			         my_dualDisplay.update(true);
					RuleManager.getInstance().defaultProcess = false;
			        }
			      });
	
		my_dualDisplay=new DualDisplay(this,container);
 
	  	setControl(container);
  }
	//This method allows to check if the next button should be active
	@Override
	public boolean canFlipToNextPage(){
		
		if( DualDisplay.getList().length==0 && !isSelected )	
			return false;
			else if (DualDisplay.getList().length!=0  )
				return true;
				else 			
					return true;
	}

	public IWizardPage getNextPage(){   
		ExtractionProcessWizard page = null;
		page = ((EconetWizard)getWizard()).extractionProcessPage;
		RuleManager.getInstance().listNameOfRuleProcess = DualDisplay.getList();
		return page;
	}
	
	
	public void handleEvent(Event event) {
		getWizard().getContainer().updateButtons();
	}



}
