package testjdt3;
import java.util.Vector;


/**
 * Class for storing structure.
 * @author jroyer
 *
 */
public class Structure {
	
	/**
	 * List of ivar names.
	 */
	private Vector<String> ivars;
	
	/**
	 * List of types.
	 */
	private Vector<String> types;
	
	/**
	 * Constructor.
	 * @param ivs
	 * @param tps
	 */
	public Structure(Vector<String> ivs, Vector<String> tps) {
		this.ivars = ivs;
		this.types = tps;
	}
	
	public boolean isdefined(String iv) {
		return this.ivars.contains(iv);
	}
	
	public String getTypes(String iv) {
		if (this.isdefined(iv)) {
			int ind = this.ivars.indexOf(iv);
			return this.types.get(ind);
		} else {
			System.err.println(" Structure unknown ivars " + iv);
			return "";
		}
	}
	
	/**
	 * String representation.
	 */
	public String toString() {
		String result = "[";
		for (int i = 0; i < this.ivars.size(); i++) {
			result += this.ivars.get(i) + " : " + this.types.get(i) + " ";
		}
		return result + "]";
	}

}
