package testjdt3;

import java.util.Vector;

import org.eclipse.jdt.core.dom.ITypeBinding;

/**
 * Store type information for structure computation.
 * Uniquely defined by typename which must be the binary/fullqualifiednamed
 * @author jroyer
 *
 */
public class TypeInfo {
	
	/**
	 * Type name.
	 */
	private String typename;
	
	/**
	 * Type object resolved.
	 */
	private ITypeBinding resolved;
	
	/**
	 * ivars names.
	 */
	private Vector<String> ivars;
	
	public TypeInfo(String n) {
		this.typename = n;
	}
	
	public TypeInfo(String n, ITypeBinding itb) {
		this.typename = n;
		this.resolved = itb;
	}

	public String toString() {
		String result = "";
		result += this.typename + " -> " + this.resolved.getBinaryName();
		return result;
	}
}
