package testjdt3;

import java.util.HashMap;
import java.util.Vector;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;

/**
 * Table for storing informations about the types.
 * @author jroyer
  */
public class TypesTable extends  HashMap<String, Information>{

	/**
	 * Constructor.
	 * @param vt
	 */
	public TypesTable(Vector<IType> vt) {
		super();
		for (int i = 0; i < vt.size(); i++) {
			this.put(vt.get(i).getFullyQualifiedName(), new Information());
		}
	}
	
	/**
	 * Check the existence of such a type.
	 * @param fn
	 * @return
	 */
	public boolean isOfInterest(String fn) {
		return this.containsKey(fn);
	}
	
	/**
	 * Check if it is flagged as a data type.
	 *  Require this.isOfInterest()
	 * @param fn
	 * @return
	 */
	public boolean isDataType(String fn) {
		return this.get(fn).isDataType();
	}

	/**
	 * Check if the type name is resolved
	 * Require this.isOfInterest()
	 * @param fn
	 * @return
	 */
	public boolean isResolved(String fn) {
		return (this.get(fn).isResolved());
	}
	
	/**
	 * Test fields existence.
	 * @param fn
	 * @return
	 */
	public boolean hasFields(String fn) {
		return this.get(fn).hasFields();
	}
	
	/**
	 * Set that name is a data type.
	 * @param bn binary name
	 */
	public void setDataType(String bn) {
		if (this.containsKey(bn)) {
			Information inf = this.get(bn);
			inf.setDataType(true);
			this.put(bn, inf);
		}
	}
	
	/**
	 * Set that name is a component type.
	 * @param bn binary name
	 */
	public void setComponentType(String bn) {
		if (this.containsKey(bn)) {
			Information inf = this.get(bn);
			inf.setComponentType(true);
			this.put(bn, inf);
		}
	}
	
	/**
	 * Set as THE root name. 
	 * @param bn
	 */
	public void setRoot(String bn) {
		if (this.containsKey(bn)) {
			Information inf = this.get(bn);
			inf.setRoot();
			this.put(bn, inf);
		}
	}
	
	/**
	 * Add a new entry and its information.
	 * @param fn
	 * @param it
	 */
	public void addType(String fn, Information it) {
		this.put(fn, it);
	}
	
	/**
	 * Set the information type for a name.
	 * @param bn
	 * @param it
	 */
	public void setType(String bn, MyIType it) {
		if (this.containsKey(bn)) {
			Information inf = this.get(bn);
			inf.setType(it);
			this.put(bn, inf);
		} else {
			MessageDialog.openError(ASTActionDelegate.shell, "Error" , " TypesTable.setType inconnu  " + bn);
		}
	}
	
	/**
	 * Setting default null information.
	 * @param bn
	 */
	public void setType(String bn) {
			this.put(bn, new Information());
	}
	
	/**
	 * Get the structure stored in the table.
	 * @param fullname
	 * @return
	 */
	public Fields getStructure(String fullname) {
		return this.get(fullname).getIbind().getStructure();
	}
	
	/**
	 * String description.
	 */
	public String toString() {
		String result = "";
		for (String key : this.keySet()) {
			result += key  + " -> " + this.get(key) + "\n";
		}
		return result;
	}
	
}
