/*
 * @(#)Ocl.java
 *
 * Copyright (c) 2003 Computer Science Research Laboratory,
 * "Babes-Bolyai" University, Cluj-Napoca, ROMANIA.
 * All Rights Reserved.
 */
package ro.ubbcluj.lci.codegen.framework.ocl;
import java.util.*;

import ro.ubbcluj.lci.codegen.framework.dt.Real;

/**
 * Contains utility methods. Implements the operations in OclAny
 *
 * @author Cristian Botiza
 */
public final class Ocl {
	/**
	 * The 'oclInState' operation in OclAny
	 *
	 * @param self The object on which this test is performed. Not used for now
	 * @param stateSpec Generic state specification. Not used for now
	 * @return false (as for this version)
	 */
	public static boolean inState(Object self, Object stateSpec) {
		return false;
	}
	
	/**
	 * The 'oclIsTypeOf' operation in OclAny
	 *
	 * @param self The object on which the operation is called. May also be null.
	 * @param type The test type. May also be null.
	 * @return true if type.equals(the type of <code>self</code>), false otherwise
	 */
	public static boolean isTypeOf(Object self, OclType type) {
		return self != null && type != null ? type.equals(type(self)) : false;
	}
	
	/**
	 * The 'oclIsKindOf' operation in OclAny
	 *
	 * @param self The object on which the operation is called. May also be null.
	 * @param type The test type. May also be null.
	 * @return The value <code>self.oclIsKindOf(type)</code>
	 */
	public static boolean isKindOf(Object self, OclType type) {
		//undefined conforms to ALL types!!!
		return self == null ? true : (type == null ? false : Ocl.type(self).conforms(type));
	}
	
	/**
	 * Determines the type of the given object. Introspects collections if necessary
	 *
	 * @param self The object whose type must be determined. May be null, in which case it is considered the OCL Undefined constant
	 * @return The type of the given object. If <code>self</code> is null, OclType(Object.class) is returned
	 */
	public static OclType type(Object self) {
		if (self == null) {
			return new OclType(Object.class);
		}
		Class c = self.getClass();
		OclType ret = new OclType(c);
		if (List.class.isAssignableFrom(c) || Set.class.isAssignableFrom(c)) {
			Collection tc = (Collection)self;
			Iterator it = tc.iterator();
			OclType[] types = new OclType[tc.size()];
			int i = 0;
			while (it.hasNext()) {
				types[i++] = type(it.next());
			}
			ret.setInnerType(OclType.commonType(types));
		}
		return ret;
	}
	
	/**
	 * The 'isUndefined' operation in OclAny. The implementation
	 * also checks the wrapped value if <code>self</code> has
	 * a primitive type (Integer/Real).
	 *
	 * @param self Any object. May also be null.
	 * @return true if self is null or self is not a 'normal' real/integer
	 */
	public static boolean isUndefined(Object self) {
		if (self instanceof ro.ubbcluj.lci.codegen.framework.dt.Integer) {
			return Math.abs(((ro.ubbcluj.lci.codegen.framework.dt.Integer)self).asInteger()) == java.lang.Integer.MAX_VALUE;
		}
		
		if (self instanceof Real) {
			return Math.abs(((Real)self).asReal()) == Float.POSITIVE_INFINITY;
		}
		
		return self == null;
	}
	
	/**
	 * The 'isDefined' operation in OclAny. The implementation
	 * also checks the wrapped value if <code>self</code> has
	 * a primitive type (OclInteger/OclReal).
	 *
	 * @param self Any object. May also be null.
	 * @return true if self is not null or self is a 'normal' real/integer
	 */
	public static boolean isDefined(Object self) {
		if (self instanceof ro.ubbcluj.lci.codegen.framework.dt.Integer) {
			return Math.abs(((ro.ubbcluj.lci.codegen.framework.dt.Integer)self).asInteger()) <
				java.lang.Integer.MAX_VALUE;
		}
		
		if (self instanceof Real) {
			return Math.abs(((Real)self).asReal()) < Float.POSITIVE_INFINITY;
		}
		
		return self != null;
	}
	
	/**
	 * The 'oclIsNew' operation in OclAny. This implementation is a convenience one.
	 *
	 * @param self Any object. This parameter is ignored for now
	 * @return false
	 */
	public static boolean isNew(Object self) {
		return false;
	}

    /**
     * Creates an OclType object for a 'simple' (non-collection) type.
     * @param c The Class object for that type
     */
    public static final OclType getType(Class c) {
        return new OclType(c);
    }

    /**
     * Generalized version of the type creation methods
     * @param types A list of types. The creation process stops at the first non-collection descendant type in the array
     */
    public static final OclType getType(Class[] types) {
        return new OclType(types);
    }    
}
